/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import ht.treechop.client.gui.util.GUIUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StickyWidget
extends AbstractWidget {
    public static final ResourceLocation WIDGETS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/widgets.png");
    private final Supplier<State> stateSupplier;
    private final Runnable onPress;

    public StickyWidget(int x, int y, int width, int height, Component name, Runnable onPress, Supplier<State> stateSupplier) {
        super(x, y, Math.max(width, GUIUtil.getMinimumButtonWidth(name)), Math.max(height, 20), name);
        this.onPress = onPress;
        this.stateSupplier = stateSupplier;
    }

    public void onClick(double mouseX, double mouseY) {
        this.onPress.run();
    }

    public int getFGColor() {
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.active = this.stateSupplier.get() == State.Up;
        this.height = Math.min(this.height, 20);
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        if (this.stateSupplier.get() != State.Locked) {
            int i = this.getYImage(this.isHoveredOrFocused());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            gui.blit(WIDGETS_LOCATION, this.getX(), this.getY(), 0, 46 + i * 20, this.width / 2, this.height);
            gui.blit(WIDGETS_LOCATION, this.getX() + this.width / 2, this.getY(), 200 - this.width / 2, 46 + i * 20, this.width / 2, this.height);
        }
        int j = this.getFGColor();
        gui.drawCenteredString(minecraft.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | (int)Math.ceil(this.alpha * 255.0f) << 24);
    }

    private int getYImage(boolean hoveredOrFocused) {
        return this.active ? (hoveredOrFocused ? 2 : 1) : 0;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static enum State {
        Up,
        Down,
        Locked;


        public static State of(boolean enabled, boolean canBeEnabled) {
            if (canBeEnabled) {
                return enabled ? Down : Up;
            }
            return Locked;
        }
    }
}

