/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop;

import ht.treechop.TreeChop;
import ht.treechop.TreeChopNeoForgeAPI;
import ht.treechop.client.NeoForgeClientProxy;
import ht.treechop.common.NeoForgePlatform;
import ht.treechop.common.NeoForgeRegistry;
import ht.treechop.common.config.ConfigHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="treechop")
public class TreeChopNeoForge
extends TreeChop {
    public TreeChopNeoForge(ModContainer container, IEventBus modBus) {
        platform = new NeoForgePlatform();
        api = new TreeChopNeoForgeAPI("treechop");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        NeoForgeRegistry.Blocks.REGISTRY.register(modBus);
        NeoForgeRegistry.BlockEntities.REGISTRY.register(modBus);
        NeoForgeRegistry.LootConditionTypes.REGISTRY.register(modBus);
        modBus.addListener(this::processIMC);
        modBus.addListener(event -> ConfigHandler.onReload());
        modBus.addListener(event -> event.register(Registries.SOUND_EVENT, helper -> helper.register(CHOP_WOOD, (Object)((SoundEvent)CHOP_WOOD_EVENT.get()))));
        NeoForge.EVENT_BUS.addListener(event -> ConfigHandler.updateTags());
        if (FMLLoader.getDist() == Dist.CLIENT) {
            NeoForgeClientProxy.init(modBus);
        }
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream(message -> message.equalsIgnoreCase("getTreeChopAPI")).forEach(action -> {
            Supplier supplier = action.messageSupplier();
            try {
                Consumer consumer = (Consumer)supplier.get();
                consumer.accept(new TreeChopNeoForgeAPI(action.senderModId()));
            }
            catch (ClassCastException | NullPointerException e) {
                TreeChop.LOGGER.error(String.format("Failed to process getTreeChopAPI request from %s: %s", action.senderModId(), e.getMessage()));
                e.printStackTrace();
            }
        });
    }
}

