/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.ITreeChopBlockBehavior;
import ht.treechop.api.TreeChopAPI;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class TreeChopInternalAPI
implements TreeChopAPI {
    private static final Map<Block, ITreeChopBlockBehavior> blockBehaviors = new HashMap<Block, ITreeChopBlockBehavior>();
    private static final Map<Block, Boolean> choppableBlockOverrides = new HashMap<Block, Boolean>(){

        @Override
        public Boolean put(Block block, Boolean isChoppable) {
            ConfigHandler.COMMON.choppableBlocks.reset();
            return super.put(block, isChoppable);
        }
    };
    private static final Map<Block, Boolean> leavesBlockOverrides = new HashMap<Block, Boolean>(){

        @Override
        public Boolean put(Block block, Boolean isLeaves) {
            ConfigHandler.COMMON.leavesBlocksAndBehaviors.reset();
            return super.put(block, isLeaves);
        }
    };
    private static final Map<Item, IChoppingItem> choppingItemBehaviors = new HashMap<Item, IChoppingItem>();
    private static final Map<Item, Boolean> choppingItemOverrides = new HashMap<Item, Boolean>();
    private static final Marker API_MARKER = MarkerManager.getMarker((String)"API");
    private final String modId;

    TreeChopInternalAPI(String modId) {
        this.modId = modId;
    }

    private void print(String message) {
        if (((Boolean)ConfigHandler.COMMON.verboseAPI.get()).booleanValue()) {
            TreeChop.LOGGER.info(API_MARKER, "API [{}] {}", (Object)this.modId, (Object)message);
        }
    }

    @Override
    public void overrideChoppableBlock(Block block, boolean isChoppable) {
        choppableBlockOverrides.put(block, isChoppable);
        this.print(String.format("set isChoppable=%s for block %s", isChoppable, TreeChop.platform.getResourceLocationForBlock(block)));
    }

    @Override
    public void overrideLeavesBlock(Block block, boolean isLeaves) {
        leavesBlockOverrides.put(block, isLeaves);
        this.print(String.format("set isLeaves=%s for block %s", isLeaves, TreeChop.platform.getResourceLocationForBlock(block)));
    }

    @Override
    public void overrideChoppingItem(Item item, boolean canChop) {
        choppingItemOverrides.put(item, canChop);
        this.print(String.format("set canChop=%s for item %s", canChop, TreeChop.platform.getResourceLocationForItem(item)));
    }

    @Override
    public void registerBlockBehavior(Block block, ITreeChopBlockBehavior handler) {
        blockBehaviors.put(block, handler);
        this.print(String.format("registered new behavior for block %s", TreeChop.platform.getResourceLocationForBlock(block)));
    }

    @Override
    public boolean deregisterBlockBehavior(Block block) {
        ITreeChopBlockBehavior existing = blockBehaviors.remove(block);
        this.print(String.format("deregistered behavior for block %s", TreeChop.platform.getResourceLocationForBlock(block)));
        return existing == null;
    }

    @Override
    public ITreeChopBlockBehavior getRegisteredBlockBehavior(Block block) {
        return blockBehaviors.get(block);
    }

    @Override
    public void registerChoppableBlockBehavior(Block block, ITreeChopBlockBehavior handler) {
        this.registerBlockBehavior(block, handler);
    }

    @Override
    public boolean deregisterChoppableBlockBehavior(Block block) {
        return this.deregisterBlockBehavior(block);
    }

    @Override
    public ITreeChopBlockBehavior getRegisteredChoppableBlockBehavior(Block block) {
        return this.getRegisteredBlockBehavior(block);
    }

    @Override
    public void registerChoppingItemBehavior(Item item, IChoppingItem handler) {
        choppingItemBehaviors.put(item, handler);
        this.print(String.format("registered new behavior for item %s", TreeChop.platform.getResourceLocationForItem(item)));
    }

    @Override
    public boolean deregisterChoppingItemBehavior(Item item) {
        IChoppingItem existing = choppingItemBehaviors.remove(item);
        this.print(String.format("deregistered behavior for item %s", TreeChop.platform.getResourceLocationForItem(item)));
        return existing == null;
    }

    @Override
    public IChoppingItem getRegisteredChoppingItemBehavior(Item item) {
        return choppingItemBehaviors.get(item);
    }

    @Override
    public boolean isBlockChoppable(Level level, BlockPos pos, BlockState blockState) {
        return ChopUtil.isBlockALog(level, pos, blockState);
    }

    @Override
    public boolean isBlockLeaves(Level level, BlockPos pos, BlockState blockState) {
        return ChopUtil.isBlockLeaves(blockState);
    }

    @Override
    public boolean canChopWithItem(Player player, ItemStack stack, Level level, BlockPos pos, BlockState blockState) {
        return ChopUtil.canChopWithTool(player, stack, level, pos, blockState);
    }

    @Override
    public TreeData getTree(Level level, BlockPos pos) {
        return ChopUtil.getTree(level, pos);
    }

    public Stream<Pair<Block, Boolean>> getChoppableBlockOverrides() {
        return choppableBlockOverrides.entrySet().stream().map(entry -> Pair.of((Object)((Block)entry.getKey()), (Object)((Boolean)entry.getValue())));
    }

    public Stream<Pair<Block, Boolean>> getLeavesBlockOverrides() {
        return leavesBlockOverrides.entrySet().stream().map(entry -> Pair.of((Object)((Block)entry.getKey()), (Object)((Boolean)entry.getValue())));
    }

    public Stream<Pair<Item, Boolean>> getChoppingItemOverrides() {
        return choppingItemOverrides.entrySet().stream().map(entry -> Pair.of((Object)((Item)entry.getKey()), (Object)((Boolean)entry.getValue())));
    }
}

