/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.content.trading_depot;

import com.cake.trading_floor.content.trading_depot.TradingDepotBlock;
import com.cake.trading_floor.content.trading_depot.TradingDepotBlockEntity;
import com.cake.trading_floor.content.trading_depot.behavior.TradingDepotBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TradingDepotRenderer
extends SmartBlockEntityRenderer<TradingDepotBlockEntity> {
    public TradingDepotRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(TradingDepotBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        TradingDepotBehaviour behaviour = (TradingDepotBehaviour)blockEntity.getBehaviour(TradingDepotBehaviour.TYPE);
        TransportedItemStack transported = behaviour.getOffer();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        ms.pushPose();
        ms.translate(0.5, 1.0, 0.5);
        ArrayList<TransportedItemStack> tisStacks = new ArrayList<TransportedItemStack>(behaviour.getIncoming());
        if (transported != null) {
            tisStacks.add(transported);
        }
        for (TransportedItemStack tis : tisStacks) {
            ms.pushPose();
            msr.nudge(0);
            float offset = Mth.lerp((float)partialTicks, (float)tis.prevBeltPosition, (float)tis.beltPosition);
            float sideOffset = Mth.lerp((float)partialTicks, (float)tis.prevSideOffset, (float)tis.sideOffset);
            if (tis.insertedFrom.getAxis().isHorizontal()) {
                Vec3 offsetVec = Vec3.atLowerCornerOf((Vec3i)tis.insertedFrom.getOpposite().getNormal()).scale((double)(0.5f - offset));
                ms.translate(offsetVec.x, offsetVec.y, offsetVec.z);
                boolean bl = tis.insertedFrom.getClockWise().getAxis() == Direction.Axis.X;
            }
            ItemStack itemStack = tis.stack;
            int angle = tis.angle;
            Random r = new Random(0L);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees((float)(90 - ((Direction)blockEntity.getBlockState().getValue((Property)TradingDepotBlock.FACING)).get2DDataValue() * 90))).rotateZDegrees(22.5f);
            TradingDepotRenderer.renderItem(blockEntity.getLevel(), ms, buffer, light, overlay, itemStack, angle, r);
            ms.popPose();
        }
        for (int i = 0; i < behaviour.getResults().size(); ++i) {
            ItemStack stack = behaviour.getResults().get(i);
            if (stack.isEmpty()) continue;
            ms.pushPose();
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees((float)(90 - ((Direction)blockEntity.getBlockState().getValue((Property)TradingDepotBlock.FACING)).get2DDataValue() * 90))).rotateZDegrees(22.5f);
            msr.nudge(i);
            msr.rotateYDegrees((215.0f + 45.0f * (float)i) % 360.0f);
            ms.translate(0.35, 0.01 / (double)(i + 1), 0.0);
            Random r = new Random(i + 1);
            int angle = (int)(360.0f * r.nextFloat());
            TradingDepotRenderer.renderItem(blockEntity.getLevel(), ms, buffer, light, overlay, stack, angle, r);
            ms.popPose();
        }
        ms.popPose();
    }

    public static void renderItem(Level level, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack itemStack, int angle, Random r) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        int count = Mth.log2((int)itemStack.getCount()) / 2;
        boolean blockItem = itemRenderer.getModel(itemStack, null, null, 0).isGui3d();
        ms.pushPose();
        msr.rotateYDegrees((float)angle);
        for (int i = 0; i <= count; ++i) {
            ms.pushPose();
            if (blockItem) {
                ms.translate(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            ms.scale(0.5f, 0.5f, 0.5f);
            if (!blockItem) {
                ms.translate(0.0f, -0.1875f, 0.0f);
                msr.rotateXDegrees(90.0f);
            }
            itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, level, 0);
            ms.popPose();
            if (!blockItem) {
                msr.rotateYDegrees(10.0f);
            }
            ms.translate(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
        }
        ms.popPose();
    }
}

