/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.quartzarsenal.neoforge;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.neoforge.support.energy.EnergyStorageAdapter;
import com.refinedmods.refinedstorage.quartzarsenal.common.AbstractModInitializer;
import com.refinedmods.refinedstorage.quartzarsenal.common.ContentIds;
import com.refinedmods.refinedstorage.quartzarsenal.common.CreativeModeTabItems;
import com.refinedmods.refinedstorage.quartzarsenal.common.Items;
import com.refinedmods.refinedstorage.quartzarsenal.common.Platform;
import com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid.WirelessCraftingGridItem;
import com.refinedmods.refinedstorage.quartzarsenal.neoforge.ClientModInitializer;
import com.refinedmods.refinedstorage.quartzarsenal.neoforge.ConfigImpl;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="refinedstorage_quartz_arsenal")
public class ModInitializer
extends AbstractModInitializer {
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"refinedstorage_quartz_arsenal");
    private final DeferredRegister<MenuType<?>> menuTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"refinedstorage_quartz_arsenal");
    private final DeferredRegister<DataComponentType<?>> dataComponentTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"refinedstorage_quartz_arsenal");

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        ConfigImpl config = new ConfigImpl();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getSpec());
        Platform.setConfigProvider(() -> config);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
            eventBus.addListener(ClientModInitializer::onRegisterKeyMappings);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        this.registerContent(eventBus);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::registerCreativeModeTabListener);
    }

    private void registerContent(IEventBus eventBus) {
        this.registerItems(eventBus);
        this.registerMenus(eventBus);
        this.registerDataComponents(eventBus);
    }

    private void registerItems(IEventBus eventBus) {
        ForgeRegistryCallback<Item> callback = new ForgeRegistryCallback<Item>(this.itemRegistry);
        this.registerCustomItems(callback);
        this.itemRegistry.register(eventBus);
    }

    private void registerCustomItems(RegistryCallback<Item> callback) {
        Items.INSTANCE.setWirelessCraftingGrid(callback.register(ContentIds.WIRELESS_CRAFTING_GRID, () -> new WirelessCraftingGridItem(this, false, RefinedStorageApi.INSTANCE.getEnergyItemHelper(), RefinedStorageApi.INSTANCE.getNetworkItemHelper()){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setCreativeWirelessCraftingGrid(callback.register(ContentIds.CREATIVE_WIRELESS_CRAFTING_GRID, () -> new WirelessCraftingGridItem(this, true, RefinedStorageApi.INSTANCE.getEnergyItemHelper(), RefinedStorageApi.INSTANCE.getNetworkItemHelper()){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
    }

    private void registerMenus(IEventBus eventBus) {
        this.registerMenus(new ForgeRegistryCallback(this.menuTypeRegistry), new ExtendedMenuTypeFactory(this){

            public <T extends AbstractContainerMenu, D> MenuType<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
                return IMenuTypeExtension.create((syncId, inventory, buf) -> {
                    Object data = streamCodec.decode((Object)buf);
                    return supplier.create(syncId, inventory, data);
                });
            }
        });
        this.menuTypeRegistry.register(eventBus);
    }

    private void registerDataComponents(IEventBus eventBus) {
        ForgeRegistryCallback callback = new ForgeRegistryCallback(this.dataComponentTypeRegistry);
        this.registerDataComponents(callback);
        this.dataComponentTypeRegistry.register(eventBus);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerEnergyItemProviders(event);
    }

    private void registerEnergyItemProviders(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new EnergyStorageAdapter(Items.INSTANCE.getWirelessCraftingGrid().createEnergyStorage((ItemStack)stack)), new ItemLike[]{Items.INSTANCE.getWirelessCraftingGrid()});
    }

    private void registerCreativeModeTabListener(BuildCreativeModeTabContentsEvent e) {
        ResourceKey creativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getCreativeModeTabId());
        if (!e.getTabKey().equals(creativeModeTab)) {
            return;
        }
        CreativeModeTabItems.addItems(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
    }

    private record ForgeRegistryCallback<T>(DeferredRegister<T> registry) implements RegistryCallback<T>
    {
        public <R extends T> Supplier<R> register(ResourceLocation id, Supplier<R> value) {
            return this.registry.register(id.getPath(), value);
        }
    }
}

