/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.fluidTrasmitter;

import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidTransmitterInventoryHandler
extends CombinedTankWrapper {
    protected final Supplier<INBTSerializable<CompoundTag>> superWrapper;

    public FluidTransmitterInventoryHandler(Supplier<INBTSerializable<CompoundTag>> handlers) {
        super(new IFluidHandler[]{(IFluidHandler)handlers.get()});
        this.superWrapper = handlers;
    }

    public IFluidHandler superWrapper() {
        return (IFluidHandler)this.superWrapper.get();
    }

    protected IFluidHandler getHandlerFromIndex(int index) {
        if (index != 0) {
            return EmptyFluidHandler.INSTANCE;
        }
        return this.superWrapper();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return resource;
        }
        FluidStack drained = FluidStack.EMPTY;
        resource = resource.copy();
        IFluidHandler iFluidHandler = this.superWrapper();
        FluidStack drainedFromCurrent = iFluidHandler.drain(resource, action);
        int amount = drainedFromCurrent.getAmount();
        resource.shrink(amount);
        if (!drainedFromCurrent.isEmpty() && (drained.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)drainedFromCurrent, (FluidStack)drained))) {
            drained = new FluidStack((Holder)drainedFromCurrent.getFluid().builtInRegistryHolder(), amount + drained.getAmount(), drainedFromCurrent.getComponents().asPatch());
        }
        return drained;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = FluidStack.EMPTY;
        IFluidHandler iFluidHandler = this.superWrapper();
        FluidStack drainedFromCurrent = iFluidHandler.drain(maxDrain, action);
        int amount = drainedFromCurrent.getAmount();
        if (!drainedFromCurrent.isEmpty() && (drained.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)drainedFromCurrent, (FluidStack)drained))) {
            drained = new FluidStack((Holder)drainedFromCurrent.getFluid().builtInRegistryHolder(), amount + drained.getAmount(), drainedFromCurrent.getComponents().asPatch());
        }
        return drained;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int filled = 0;
        resource = resource.copy();
        boolean fittingHandlerFound = false;
        for (boolean searchPass : Iterate.trueAndFalse) {
            IFluidHandler iFluidHandler = this.superWrapper();
            for (int i = 0; i < iFluidHandler.getTanks(); ++i) {
                if (!searchPass || !iFluidHandler.getFluidInTank(i).isFluidEqual(resource)) continue;
                fittingHandlerFound = true;
            }
            if (searchPass && !fittingHandlerFound) continue;
            int filledIntoCurrent = iFluidHandler.fill(resource, action);
            resource.shrink(filledIntoCurrent);
            filled += filledIntoCurrent;
            if (resource.isEmpty() || fittingHandlerFound && (this.enforceVariety || filledIntoCurrent != 0)) break;
        }
        return filled;
    }
}

