/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.v2.emissive.neoforge;

import com.blackgear.platform.client.v2.emissive.EmissiveModelWrapper;
import com.blackgear.platform.client.v2.emissive.EmissiveModelWrapperHolder;
import com.blackgear.platform.client.v2.emissive.Emissiveness;
import com.blackgear.platform.client.v2.emissive.neoforge.ForgeEmissiveLayerBakedModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class EmissiveModelWrapperImpl {
    public static void bootstrap() {
        IEventBus bus = ModLoadingContext.get().getActiveContainer().getEventBus();
        if (bus == null) {
            return;
        }
        bus.addListener(event -> {
            @Nullable EmissiveModelWrapper handler = ((EmissiveModelWrapperHolder)event.getModelBakery()).getModelWrapper();
            if (handler == null) {
                return;
            }
            HashMap<ModelResourceLocation, BakedModel> replacements = null;
            for (Map.Entry entry : event.getModels().entrySet()) {
                ModelResourceLocation id = (ModelResourceLocation)entry.getKey();
                BakedModel model = (BakedModel)entry.getValue();
                if (!"minecraft".equals(id.id().getNamespace()) || model == null || model instanceof ForgeEmissiveLayerBakedModel || model.isCustomRenderer() || !Emissiveness.hasEmissiveSprite(model)) continue;
                try {
                    if (model.getRenderPasses(ItemStack.EMPTY, false).size() > 1) {
                    }
                }
                catch (Exception ignored) {}
                continue;
                if (replacements == null) {
                    replacements = new HashMap<ModelResourceLocation, BakedModel>();
                }
                replacements.put(id, handler.wrap(model, id.id()));
            }
            if (replacements != null && !replacements.isEmpty()) {
                event.getModels().putAll(replacements);
            }
        });
    }

    public static BakedModel getBakedModel(BakedModel model) {
        return new ForgeEmissiveLayerBakedModel(model);
    }
}

