/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.integration;

import com.blackgear.platform.common.integration.BlockInteraction;
import com.blackgear.platform.common.integration.neoforge.BlockIntegrationImpl;
import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BlockIntegration {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerIntegrations(Consumer<Event> listener) {
        BlockIntegrationImpl.registerIntegrations(listener);
    }

    public static interface Event {
        public void registerBlockInteraction(BlockInteraction var1);

        public void registerFuelItem(ItemLike var1, int var2);

        public void registerCompostableItem(ItemLike var1, float var2);

        default public void registerDispenserBehavior(ItemLike item, DispenseItemBehavior behavior) {
            DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)behavior);
        }

        default public void registerStrippableBlock(Block target, Block result) {
            AxeItem.STRIPPABLES = Maps.newHashMap((Map)AxeItem.STRIPPABLES);
            AxeItem.STRIPPABLES.putIfAbsent(target, result);
        }

        default public void registerFlattenableBlock(Block target, BlockState result) {
            ShovelItem.FLATTENABLES.putIfAbsent(target, result);
        }

        default public void registerFlattenableBlock(Block target, Block result) {
            this.registerFlattenableBlock(target, result.defaultBlockState());
        }

        default public void registerFlammableBlock(Block target, int encouragement, int flammability) {
            ((FireBlock)Blocks.FIRE).setFlammable(target, encouragement, flammability);
        }
    }
}

