/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.mixin.iris;

import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.impl.event.RenderContextImpl;
import net.irisshaders.iris.mixin.LevelRendererAccessor;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.leonx.irisflw.flywheel.RenderLayerEventStateManager;

@Mixin(value={ShadowRenderer.class})
public abstract class MixinShadowRenderer {
    @Final
    @Shadow
    private boolean shouldRenderBlockEntities;
    @Final
    @Shadow
    private RenderBuffers buffers;

    @Inject(method={"renderShadows"}, at={@At(value="HEAD")})
    private void injectRenderShadow(LevelRendererAccessor levelRendererAccessor, Camera camera, CallbackInfo ci) {
        if (this.shouldRenderBlockEntities) {
            RenderLayerEventStateManager.setRenderingShadow(true);
        }
    }

    @Inject(method={"renderShadows"}, at={@At(value="TAIL")})
    private void injectRenderShadowTail(LevelRendererAccessor levelRendererAccessor, Camera camera, CallbackInfo ci) {
        RenderLayerEventStateManager.setRenderingShadow(false);
    }

    @Inject(method={"renderShadows"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=draw entities"})})
    private void injectRenderShadowBeforeDrawEntities(LevelRendererAccessor levelRenderer, Camera playerCamera, CallbackInfo ci) {
        if (this.shouldRenderBlockEntities) {
            Matrix4f modelMatrix = ShadowRenderer.MODELVIEW;
            Matrix4f projectionMatrix = ShadowRenderer.PROJECTION;
            DeltaTracker deltaTracker = Minecraft.getInstance().getTimer();
            RenderContextImpl flywheel$renderContext = RenderContextImpl.create((LevelRenderer)((LevelRenderer)levelRenderer), (ClientLevel)levelRenderer.getLevel(), (RenderBuffers)this.buffers, (Matrix4fc)modelMatrix, (Matrix4f)projectionMatrix, (Camera)playerCamera, (float)deltaTracker.getGameTimeDeltaPartialTick(false));
            VisualizationManager manager = VisualizationManager.get((LevelAccessor)levelRenderer.getLevel());
            if (manager != null) {
                manager.renderDispatcher().afterEntities((RenderContext)flywheel$renderContext);
            }
        }
    }
}

