/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.backend.model;

import dev.engine_room.flywheel.lib.math.DataPacker;
import dev.engine_room.flywheel.lib.vertex.AbstractVertexView;
import net.irisshaders.iris.vertices.NormI8;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import top.leonx.irisflw.backend.IrisInternalVertex;
import top.leonx.irisflw.backend.model.CubiodBuilderTriView;
import top.leonx.irisflw.backend.model.IrisVertexReader;

public class IrisExtVertexView
extends AbstractVertexView {
    public static final long STRIDE = IrisInternalVertex.EXT_STRIDE;
    private final CubiodBuilderTriView triView = new CubiodBuilderTriView();
    private final Vector3f[] pos = new Vector3f[4];

    public void readAllExtended(IrisVertexReader src) {
        for (int i = 0; i < this.vertexCount; ++i) {
            float midU = src.midU(i);
            float midV = src.midV(i);
            int tangent = src.getTangent(i);
            tangent = this.repackTangent(tangent);
            int midBlock = src.getMidBlock(i);
            midBlock = this.repackMidBlock(midBlock);
            Vector2i mcEntity = src.mcEntity(i);
            short entityX = (short)mcEntity.x;
            short entityY = (short)mcEntity.y;
            this.midU(i, midU);
            this.midV(i, midV);
            this.packedTangent(i, tangent);
            this.packedMidBlock(i, midBlock);
            this.mcEntityX(i, entityX);
            this.mcEntityY(i, entityY);
        }
    }

    public long stride() {
        return IrisInternalVertex.EXT_STRIDE;
    }

    public float x(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * STRIDE));
    }

    public float y(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * STRIDE + 4L));
    }

    public float z(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * STRIDE + 8L));
    }

    public float r(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 12L)));
    }

    public float g(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 13L)));
    }

    public float b(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 14L)));
    }

    public float a(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 15L)));
    }

    public float u(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * STRIDE + 16L));
    }

    public float v(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * STRIDE + 20L));
    }

    public int overlay(int i) {
        return OverlayTexture.NO_OVERLAY;
    }

    public int light(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr + (long)index * STRIDE + 24L));
    }

    public float normalX(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 28L)));
    }

    public float normalY(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 29L)));
    }

    public float normalZ(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * STRIDE + 30L)));
    }

    public void x(int index, float x) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * STRIDE), (float)x);
    }

    public void y(int index, float y) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * STRIDE + 4L), (float)y);
    }

    public void z(int index, float z) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * STRIDE + 8L), (float)z);
    }

    public void r(int index, float r) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 12L), (byte)DataPacker.packNormU8((float)r));
    }

    public void g(int index, float g) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 13L), (byte)DataPacker.packNormU8((float)g));
    }

    public void b(int index, float b) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 14L), (byte)DataPacker.packNormU8((float)b));
    }

    public void a(int index, float a) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 15L), (byte)DataPacker.packNormU8((float)a));
    }

    public void u(int index, float u) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * STRIDE + 16L), (float)u);
    }

    public void v(int index, float v) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * STRIDE + 20L), (float)v);
    }

    public void overlay(int i, int i1) {
    }

    public void light(int index, int light) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * STRIDE + 24L), (int)light);
    }

    public void normalX(int index, float normalX) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 28L), (byte)DataPacker.packNormI8((float)normalX));
    }

    public void normalY(int index, float normalY) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 29L), (byte)DataPacker.packNormI8((float)normalY));
    }

    public void normalZ(int index, float normalZ) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * STRIDE + 30L), (byte)DataPacker.packNormI8((float)normalZ));
    }

    public void midU(int index, float midU) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * STRIDE + 32L), (int)Float.floatToIntBits(midU));
    }

    public void midV(int index, float midV) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * STRIDE + 36L), (int)Float.floatToIntBits(midV));
    }

    public void packedTangent(int index, int tangent) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * STRIDE + 40L), (int)tangent);
    }

    public void packedMidBlock(int index, int midBlock) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * STRIDE + 44L), (int)midBlock);
    }

    public void mcEntityX(int index, short blockId) {
        MemoryUtil.memPutShort((long)(this.ptr + (long)index * STRIDE + 48L), (short)blockId);
    }

    public void mcEntityY(int index, short renderType) {
        MemoryUtil.memPutShort((long)(this.ptr + (long)index * STRIDE + 50L), (short)renderType);
    }

    private int repackTangent(int packedTangent) {
        float x = NormI8.unpackX((int)packedTangent) + 1.0f;
        float y = NormI8.unpackY((int)packedTangent) + 1.0f;
        float z = NormI8.unpackZ((int)packedTangent) + 1.0f;
        float w = NormI8.unpackW((int)packedTangent) + 1.0f;
        return NormI8.pack((float)x, (float)y, (float)z, (float)w);
    }

    private int repackMidBlock(int midBlock) {
        float x = (float)(midBlock & 0xFF) * 0.015625f + 2.0f;
        float y = (float)(midBlock >> 8 & 0xFF) * 0.015625f + 2.0f;
        float z = (float)(midBlock >> 16 & 0xFF) * 0.015625f + 2.0f;
        int emission = midBlock >> 24 & 0xFF;
        return (int)(x * 64.0f) & 0xFF | ((int)(y * 64.0f) & 0xFF) << 8 | ((int)(z * 64.0f) & 0xFF) << 16 | emission << 24;
    }
}

