/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.backend;

import dev.engine_room.flywheel.backend.compile.core.Compilation;
import dev.engine_room.flywheel.backend.compile.core.ShaderCache;
import dev.engine_room.flywheel.backend.compile.core.ShaderResult;
import dev.engine_room.flywheel.backend.gl.GlObject;
import dev.engine_room.flywheel.backend.gl.shader.GlShader;
import dev.engine_room.flywheel.backend.gl.shader.ShaderType;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import top.leonx.irisflw.backend.IrisCompilation;

public class IrisShaderCache
extends ShaderCache {
    private final Map<ShaderKey, ShaderResult> inner = new HashMap<ShaderKey, ShaderResult>();

    public GlShader compile(GlslVersion glslVersion, ShaderType shaderType, String name, Consumer<Compilation> callback, List<SourceComponent> sourceComponents) {
        ShaderKey key = new ShaderKey(glslVersion, shaderType, name);
        ShaderResult cached = this.inner.get(key);
        if (cached != null) {
            return cached.unwrap();
        }
        IrisCompilation ctx = new IrisCompilation();
        ctx.version(glslVersion);
        ctx.define(shaderType.define);
        callback.accept(ctx);
        IrisShaderCache.expand(sourceComponents, arg_0 -> ((Compilation)ctx).appendComponent(arg_0));
        ShaderResult out = ctx.compile(shaderType, name);
        this.inner.put(key, out);
        return out.unwrap();
    }

    public void delete() {
        this.inner.values().stream().filter(r -> r instanceof ShaderResult.Success).map(ShaderResult::unwrap).forEach(GlObject::delete);
        this.inner.clear();
    }

    private static void expand(List<SourceComponent> rootSources, Consumer<SourceComponent> out) {
        LinkedHashSet<SourceComponent> included = new LinkedHashSet<SourceComponent>();
        for (SourceComponent component : rootSources) {
            IrisShaderCache.recursiveDepthFirstInclude(included, component);
            included.add(component);
        }
        included.forEach(out);
    }

    private static void recursiveDepthFirstInclude(Set<SourceComponent> included, SourceComponent component) {
        for (SourceComponent include : component.included()) {
            IrisShaderCache.recursiveDepthFirstInclude(included, include);
        }
        included.addAll(component.included());
    }

    private record ShaderKey(GlslVersion glslVersion, ShaderType shaderType, String name) {
    }
}

