/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.utility;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import umpaz.brewinandchewin.common.utility.AbstractedFluidIngredient;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegCompatibleFluidIngredients {
    public static final Codec<AbstractedFluidIngredient> CODEC = Codec.either((Codec)Codec.either(Exact.CODEC, Tag.CODEC), NeoForgeIngredient.CODEC).xmap(either -> (AbstractedFluidIngredient)either.map(Either::unwrap, neoForgeIngredient -> neoForgeIngredient), wrapper -> {
        if (wrapper instanceof Exact) {
            Exact exact = (Exact)wrapper;
            return Either.left((Object)Either.left((Object)exact));
        }
        if (wrapper instanceof Tag) {
            Tag tag = (Tag)wrapper;
            return Either.left((Object)Either.right((Object)tag));
        }
        if (wrapper instanceof NeoForgeIngredient) {
            NeoForgeIngredient neoForgeIngredient = (NeoForgeIngredient)wrapper;
            return Either.right((Object)neoForgeIngredient);
        }
        throw new UnsupportedOperationException("Unsupported wrapped fluid ingredient class.");
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, AbstractedFluidIngredient> STREAM_CODEC = ByteBufCodecs.either((StreamCodec)ByteBufCodecs.either(Exact.STREAM_CODEC, Tag.STREAM_CODEC), NeoForgeIngredient.STREAM_CODEC).map(either -> (AbstractedFluidIngredient)either.map(Either::unwrap, neoForgeIngredient -> neoForgeIngredient), wrapper -> {
        if (wrapper instanceof Exact) {
            Exact exact = (Exact)wrapper;
            return Either.left((Object)Either.left((Object)exact));
        }
        if (wrapper instanceof Tag) {
            Tag tag = (Tag)wrapper;
            return Either.left((Object)Either.right((Object)tag));
        }
        if (wrapper instanceof NeoForgeIngredient) {
            NeoForgeIngredient neoForgeIngredient = (NeoForgeIngredient)wrapper;
            return Either.right((Object)neoForgeIngredient);
        }
        throw new UnsupportedOperationException("Unsupported wrapped fluid ingredient class.");
    });

    public static class Exact
    implements AbstractedFluidIngredient {
        public static final Codec<Exact> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FluidStack.FLUID_NON_EMPTY_CODEC.fieldOf("id").forGetter(stack -> stack.displayStack.fluid().builtInRegistryHolder()), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(fluidStack -> {
            DataComponentPatch dataComponentPatch;
            DataComponentMap patt0$temp = fluidStack.displayStack.components();
            if (patt0$temp instanceof PatchedDataComponentMap) {
                PatchedDataComponentMap patched = (PatchedDataComponentMap)patt0$temp;
                dataComponentPatch = patched.asPatch();
            } else {
                dataComponentPatch = DataComponentPatch.EMPTY;
            }
            return dataComponentPatch;
        })).apply((Applicative)inst, (t1, t2) -> new Exact((Fluid)t1.value(), (DataComponentPatch)t2)));
        public static final StreamCodec<RegistryFriendlyByteBuf, Exact> STREAM_CODEC = AbstractedFluidStack.STREAM_CODEC.map(Exact::new, exact -> exact.displayStack);
        private final AbstractedFluidStack displayStack;

        private Exact(AbstractedFluidStack displayStack) {
            this.displayStack = displayStack;
        }

        public Exact(Fluid fluid, PatchedDataComponentMap components) {
            this.displayStack = new AbstractedFluidStack(fluid, 1000L, (DataComponentMap)components, FluidUnit.MILLIBUCKET, new FluidStack((Holder)fluid.builtInRegistryHolder(), 1000, components.asPatch()));
        }

        public Exact(Fluid fluid, DataComponentPatch patch) {
            this(fluid, PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)patch));
        }

        public Exact(Fluid fluid) {
            this(fluid, new PatchedDataComponentMap(DataComponentMap.EMPTY));
        }

        @Override
        public List<AbstractedFluidStack> displayStacks() {
            return List.of(this.displayStack);
        }

        @Override
        public boolean matches(AbstractedFluidStack wrapper) {
            if (this.displayStack.components().isEmpty()) {
                return this.displayStack.fluid().isSame(wrapper.fluid());
            }
            return this.displayStack.matches(wrapper);
        }
    }

    public static class Tag
    implements AbstractedFluidIngredient {
        public static final Codec<Tag> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(tag -> tag.fluidTag), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(tag -> {
            DataComponentPatch dataComponentPatch;
            PatchedDataComponentMap patt0$temp = tag.components;
            if (patt0$temp instanceof PatchedDataComponentMap) {
                PatchedDataComponentMap patched = patt0$temp;
                dataComponentPatch = patched.asPatch();
            } else {
                dataComponentPatch = DataComponentPatch.EMPTY;
            }
            return dataComponentPatch;
        })).apply((Applicative)inst, Tag::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Tag> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.FLUID), tag -> tag.fluidTag, (StreamCodec)DataComponentPatch.STREAM_CODEC, tag -> tag.components.asPatch(), Tag::new);
        private final HolderSet<Fluid> fluidTag;
        private final PatchedDataComponentMap components;
        private final List<AbstractedFluidStack> fluidStacks = new ArrayList<AbstractedFluidStack>();

        public Tag(HolderSet<Fluid> fluidTag, PatchedDataComponentMap components) {
            this.fluidTag = fluidTag;
            this.components = components;
        }

        public Tag(HolderSet<Fluid> fluid, DataComponentPatch patch) {
            this(fluid, PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)patch));
        }

        public Tag(HolderSet<Fluid> fluid) {
            this(fluid, new PatchedDataComponentMap(DataComponentMap.EMPTY));
        }

        public TagKey<Fluid> getTagKey() {
            return this.fluidTag.unwrapKey().orElse(null);
        }

        @Override
        public List<AbstractedFluidStack> displayStacks() {
            if (this.fluidTag.size() > 0 && this.fluidStacks.isEmpty()) {
                for (Holder fluidHolder : this.fluidTag) {
                    this.fluidStacks.add(new AbstractedFluidStack((Fluid)fluidHolder.value(), 1000L, (DataComponentMap)this.components, FluidUnit.MILLIBUCKET, new FluidStack(fluidHolder, 1000, this.components.asPatch())));
                }
            }
            return this.fluidStacks;
        }

        @Override
        public boolean matches(AbstractedFluidStack wrapper) {
            if (this.components.isEmpty()) {
                return this.fluidTag.contains((Holder)wrapper.fluid().builtInRegistryHolder());
            }
            return this.fluidTag.contains((Holder)wrapper.fluid().builtInRegistryHolder()) && wrapper.components().equals((Object)this.components);
        }
    }

    public static class NeoForgeIngredient
    implements AbstractedFluidIngredient {
        public static final Codec<NeoForgeIngredient> CODEC = FluidIngredient.CODEC.xmap(NeoForgeIngredient::new, neoForgeIngredient -> neoForgeIngredient.ingredient);
        public static final StreamCodec<RegistryFriendlyByteBuf, NeoForgeIngredient> STREAM_CODEC = FluidIngredient.STREAM_CODEC.map(NeoForgeIngredient::new, neoForgeIngredient -> neoForgeIngredient.ingredient);
        private final FluidIngredient ingredient;
        private final List<AbstractedFluidStack> displayStacks;

        public NeoForgeIngredient(FluidIngredient ingredient) {
            this.ingredient = ingredient;
            this.displayStacks = Arrays.stream(ingredient.getStacks()).map(fluidStack -> new AbstractedFluidStack(fluidStack.getFluid(), 1000L, (DataComponentMap)fluidStack.getComponents(), FluidUnit.MILLIBUCKET, fluidStack)).toList();
        }

        @Override
        public List<AbstractedFluidStack> displayStacks() {
            return this.displayStacks;
        }

        @Override
        public boolean matches(AbstractedFluidStack wrapper) {
            Object object;
            if (!wrapper.isEmpty() && (object = wrapper.loaderSpecific()) instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)object;
                return this.ingredient.test(fluidStack);
            }
            return this.ingredient.test(FluidStack.EMPTY);
        }
    }
}

