/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.event;

import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.living.EffectParticleModificationEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.attachment.RagingAttachment;
import umpaz.brewinandchewin.common.attachment.TipsyHeartsAttachment;
import umpaz.brewinandchewin.common.effect.RagingEffect;
import umpaz.brewinandchewin.common.mixin.LivingEntityAccessor;
import umpaz.brewinandchewin.common.network.clientbound.ClearKegFluidContainerComponentsClientboundPacket;
import umpaz.brewinandchewin.common.network.clientbound.SyncNumbedHeartsClientboundPacket;
import umpaz.brewinandchewin.common.network.clientbound.SyncRagingStacksClientboundPacket;
import umpaz.brewinandchewin.common.registry.BnCDamageTypes;
import umpaz.brewinandchewin.common.registry.BnCEffects;
import umpaz.brewinandchewin.common.tag.BnCTags;
import umpaz.brewinandchewin.neoforge.registry.BnCAttachments;

@EventBusSubscriber(modid="brewinandchewin")
public class BnCCommonEvents {
    @SubscribeEvent
    public static void onPlayerJoinLevel(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            Object attachment;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.hasData(BnCAttachments.TIPSY_HEARTS)) {
                attachment = (TipsyHeartsAttachment)serverPlayer.getData(BnCAttachments.TIPSY_HEARTS);
                BrewinAndChewin.getHelper().sendClientboundTracking((Entity)serverPlayer, new SyncNumbedHeartsClientboundPacket(serverPlayer.getId(), ((TipsyHeartsAttachment)attachment).getNumbedHealth(), ((TipsyHeartsAttachment)attachment).getTicksUntilDamage()));
            }
            if (serverPlayer.hasData(BnCAttachments.RAGING)) {
                attachment = (RagingAttachment)serverPlayer.getData(BnCAttachments.RAGING);
                BrewinAndChewin.getHelper().sendClientboundTracking((Entity)serverPlayer, new SyncRagingStacksClientboundPacket(serverPlayer.getId(), Optional.of(((RagingAttachment)attachment).getStacks())));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                Object attachment;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (event.getTarget().hasData(BnCAttachments.TIPSY_HEARTS)) {
                    attachment = (TipsyHeartsAttachment)event.getTarget().getData(BnCAttachments.TIPSY_HEARTS);
                    BrewinAndChewin.getHelper().sendClientbound(serverPlayer, new SyncNumbedHeartsClientboundPacket(living.getId(), ((TipsyHeartsAttachment)attachment).getNumbedHealth(), ((TipsyHeartsAttachment)attachment).getTicksUntilDamage()));
                }
                if (event.getTarget().hasData(BnCAttachments.RAGING)) {
                    attachment = (RagingAttachment)event.getTarget().getData(BnCAttachments.RAGING);
                    BrewinAndChewin.getHelper().sendClientbound(serverPlayer, new SyncRagingStacksClientboundPacket(living.getId(), Optional.of(((RagingAttachment)attachment).getStacks())));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TipsyHeartsAttachment attachment = BrewinAndChewin.getHelper().getTipsyHeartsAttachment(living);
            if (attachment != null && (double)attachment.getNumbedHealth() > 0.0) {
                if (attachment.getTicksUntilDamage() > 0) {
                    attachment.setTicksUntilDamage(attachment.getTicksUntilDamage() - 1);
                }
                if (!(attachment.getTicksUntilDamage() > 0 && living.hasEffect(BnCEffects.TIPSY) || living.level().isClientSide())) {
                    float health = living.getHealth() + living.getAbsorptionAmount();
                    int remainingHealth = Mth.ceil((float)Math.min(attachment.getNumbedHealth() - (float)(health % 1.0f > attachment.getNumbedHealth() % 1.0f ? 1 : 0), health));
                    if (remainingHealth > 0) {
                        living.hurt(living.damageSources().source(BnCDamageTypes.CARDIAC_ARREST), attachment.getNumbedHealth());
                    }
                    attachment.setNumbedHealth(0.0f);
                    BrewinAndChewin.getHelper().sendClientboundTracking((Entity)living, new SyncNumbedHeartsClientboundPacket(living.getId(), attachment.getNumbedHealth(), attachment.getTicksUntilDamage()));
                }
            }
            RagingAttachment.tick(living);
        }
    }

    @SubscribeEvent
    public static void mobEffectApplicable(MobEffectEvent.Applicable event) {
        if (event.getEntity().getType().is(BnCTags.EntityTypes.IMMUNE_TO_INTOXICATION) && event.getEffectInstance().is(BnCEffects.INTOXICATION)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player player;
        LivingEntity living;
        Object attachment;
        Entity attacker = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (target.hasEffect(BnCEffects.TIPSY) && !event.getSource().is(BnCDamageTypes.CARDIAC_ARREST)) {
            float numbedHealth;
            int amplifier = target.getEffect(BnCEffects.TIPSY).getAmplifier();
            float maximumNumbedHealth = Mth.clamp((float)(Mth.floor((float)((2.0f + (float)amplifier * 1.6f) / 2.0f)) * 2), (float)1.0f, (float)(target.getMaxHealth() - 2.0f));
            if (BrewinAndChewin.getHelper().getTipsyHeartsAttachment(target) == null) {
                BrewinAndChewin.getHelper().setTipsyHeartsAttachment(event.getEntity(), new TipsyHeartsAttachment(0.0f, 0));
            }
            if ((numbedHealth = Math.min(((TipsyHeartsAttachment)(attachment = BrewinAndChewin.getHelper().getTipsyHeartsAttachment(target))).getNumbedHealth() + event.getNewDamage(), maximumNumbedHealth)) - ((TipsyHeartsAttachment)attachment).getNumbedHealth() <= target.getHealth()) {
                event.setNewDamage(event.getNewDamage() - (numbedHealth - ((TipsyHeartsAttachment)attachment).getNumbedHealth()));
            }
            numbedHealth = numbedHealth - event.getContainer().getReduction(DamageContainer.Reduction.ARMOR) - event.getContainer().getReduction(DamageContainer.Reduction.ENCHANTMENTS) - event.getContainer().getReduction(DamageContainer.Reduction.MOB_EFFECTS);
            int ticksUntilDamage = 200 + 20 * amplifier;
            ((TipsyHeartsAttachment)attachment).setNumbedHealth(numbedHealth);
            ((TipsyHeartsAttachment)attachment).setTicksUntilDamage(ticksUntilDamage);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)new SyncNumbedHeartsClientboundPacket(target.getId(), numbedHealth, ticksUntilDamage), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (attacker instanceof LivingEntity && (!((living = (LivingEntity)attacker) instanceof Player) || (player = (Player)living).getAttackStrengthScale(0.0f) > 0.8f) && living.hasEffect(BnCEffects.RAGING) && event.getSource().is(BnCTags.DamageTypes.TRIGGERS_RAGING)) {
            float f;
            int stacks;
            if (BrewinAndChewin.getHelper().getRagingAttachment(living) == null) {
                BrewinAndChewin.getHelper().setRagingAttachment(living, new RagingAttachment(0, 0));
            }
            if ((stacks = Math.min(4, ((RagingAttachment)(attachment = BrewinAndChewin.getHelper().getRagingAttachment(living))).getStacks() + 1)) != ((RagingAttachment)attachment).getStacks() && !target.level().isClientSide()) {
                double heightAddition = living.getY(1.0) - living.getY(0.5);
                ((ServerLevel)target.level()).sendParticles(RagingAttachment.getParticleType(stacks, 0.5f), target.getX(), target.getY(0.5), target.getZ(), 12, target.getRandom().nextDouble() * 0.4 - 0.2, target.getRandom().nextDouble() * heightAddition * 2.0 - heightAddition, target.getRandom().nextDouble() * 0.4 - 0.2, 0.0);
            }
            ((RagingAttachment)attachment).setStacks(stacks);
            ((LivingEntityAccessor)living).brewinandchewin$invokeUpdateEffectVisibility();
            if (living instanceof Player) {
                Player player2 = (Player)living;
                f = player2.getCurrentItemAttackStrengthDelay();
            } else {
                f = 30.0f;
            }
            ((RagingAttachment)attachment).setTicksUntilReset(Mth.ceil((float)(2.5f * f)));
        }
    }

    @SubscribeEvent
    public static void effectParticleModification(EffectParticleModificationEvent event) {
        if (event.getEffect().getEffect().value() instanceof RagingEffect) {
            LivingEntity entity = event.getEntity();
            event.setParticleOptions(RagingAttachment.getParticleType(entity.getExistingData(BnCAttachments.RAGING).isEmpty() ? 0 : ((RagingAttachment)entity.getData(BnCAttachments.RAGING)).getStacks(), 0.75f));
        }
    }

    @SubscribeEvent
    public static void sendClearFluidContainerTextComponents(OnDatapackSyncEvent event) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClearKegFluidContainerComponentsClientboundPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

