/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.integration.jei.CheeseAgingRecipe;
import umpaz.brewinandchewin.integration.jei.KegFermentingPouringRecipe;

public class BnCJEIRecipes {
    private final RecipeManager recipeManager;

    public BnCJEIRecipes() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("minecraft world must not be null.");
        }
        this.recipeManager = level.getRecipeManager();
    }

    public List<KegFermentingPouringRecipe> getKegRecipes() {
        List ferms = this.recipeManager.getAllRecipesFor(BnCRecipeTypes.FERMENTING);
        List pours = this.recipeManager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING);
        ArrayList<KegFermentingPouringRecipe> kegRecipes = new ArrayList<KegFermentingPouringRecipe>();
        for (RecipeHolder fermentingRecipe : ferms) {
            if (((KegFermentingRecipe)fermentingRecipe.value()).getResult().left().isPresent()) {
                for (RecipeHolder pouringRecipe : pours) {
                    if (!((KegPouringRecipe)pouringRecipe.value()).getRawFluid().matches((AbstractedFluidStack)((KegFermentingRecipe)fermentingRecipe.value()).getResult().left().get())) continue;
                    kegRecipes.add(new KegFermentingPouringRecipe(fermentingRecipe.id(), (KegFermentingRecipe)fermentingRecipe.value(), (KegPouringRecipe)pouringRecipe.value(), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
                }
                continue;
            }
            kegRecipes.add(new KegFermentingPouringRecipe(fermentingRecipe.id(), (KegFermentingRecipe)fermentingRecipe.value(), null, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        }
        return kegRecipes;
    }

    public List<CheeseAgingRecipe> getCheeseRecipes() {
        ArrayList<CheeseAgingRecipe> cheese = new ArrayList<CheeseAgingRecipe>();
        cheese.add(new CheeseAgingRecipe(BnCBlocks.UNRIPE_FLAXEN_CHEESE_WHEEL.asItem(), BnCBlocks.FLAXEN_CHEESE_WHEEL.asItem()));
        cheese.add(new CheeseAgingRecipe(BnCBlocks.UNRIPE_SCARLET_CHEESE_WHEEL.asItem(), BnCBlocks.SCARLET_CHEESE_WHEEL.asItem()));
        return cheese;
    }
}

