/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.data.builder;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import umpaz.brewinandchewin.client.recipebook.FermentingBookCategory;
import umpaz.brewinandchewin.common.crafting.FluidIngredientWithAmount;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.utility.AbstractedFluidIngredient;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.neoforge.utility.KegCompatibleFluidIngredients;

public class KegFermentingRecipeBuilder {
    private int ingredientCount = 0;
    private final NonNullList<Ingredient> ingredients = NonNullList.withSize((int)4, (Object)Ingredient.EMPTY);
    private final FermentingBookCategory tab;
    private Optional<FluidIngredientWithAmount> fluidIngredient = Optional.empty();
    private Optional<FluidUnit> unit = Optional.empty();
    private Either<AbstractedFluidStack, ItemStack> result = null;
    private final int fermentingTime;
    private final float experience;
    private final int temperature;
    private final int amount;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();

    private KegFermentingRecipeBuilder(FermentingBookCategory tab, int amount, int fermentingTime, float experience, int temperature) {
        this.fermentingTime = fermentingTime;
        this.tab = tab;
        this.experience = experience;
        this.temperature = temperature;
        this.amount = amount;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(FermentingBookCategory tab, Item item, int amount, int fermentingTime, float experience, int temperature) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(tab, amount, fermentingTime, experience, temperature);
        i.setResult(item);
        return i;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(FermentingBookCategory tab, Fluid fluid, int amount, int fermentingTime, float experience, int temperature) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(tab, amount, fermentingTime, experience, temperature);
        i.setResult(fluid);
        return i;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(FermentingBookCategory tab, Item item, int amount, int fermentingTime, float experience) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(tab, amount, fermentingTime, experience, 3);
        i.setResult(item);
        return i;
    }

    public static KegFermentingRecipeBuilder kegFermentingRecipe(FermentingBookCategory tab, Fluid fluid, int amount, int fermentingTime, float experience) {
        KegFermentingRecipeBuilder i = new KegFermentingRecipeBuilder(tab, amount, fermentingTime, experience, 3);
        i.setResult(fluid);
        return i;
    }

    public KegFermentingRecipeBuilder setFluidUnit(FluidUnit unit) {
        if (this.result.left().isPresent() && ((AbstractedFluidStack)this.result.left().get()).unit() != unit) {
            throw new UnsupportedOperationException("You need to set your fluid unit after your result.");
        }
        this.unit = Optional.of(unit);
        return this;
    }

    private void setResult(Fluid fluid) {
        this.result = Either.left((Object)new AbstractedFluidStack(fluid, this.amount));
    }

    private void setResult(FluidStack fluid) {
        this.result = Either.left((Object)new AbstractedFluidStack(fluid.getFluid(), fluid.getAmount(), (DataComponentMap)fluid.getComponents(), this.unit.orElse(FluidUnit.getLoaderUnit()), fluid));
    }

    private void setResult(Item item) {
        this.result = Either.right((Object)item.getDefaultInstance().copyWithCount(this.amount));
    }

    private void setResult(ItemStack stack) {
        this.result = Either.right((Object)stack.copyWithCount(this.amount));
    }

    public KegFermentingRecipeBuilder addIngredient(TagKey<Item> tagIn) {
        return this.addIngredient(Ingredient.of(tagIn));
    }

    public KegFermentingRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public KegFermentingRecipeBuilder addIngredient(ItemLike itemIn, int quantity) {
        this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{itemIn}), quantity);
        return this;
    }

    public KegFermentingRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public KegFermentingRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.set(this.ingredientCount, (Object)ingredientIn);
            ++this.ingredientCount;
        }
        return this;
    }

    public KegFermentingRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.advancement.addCriterion(criterionName, criterionTrigger);
        return this;
    }

    public KegFermentingRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public KegFermentingRecipeBuilder unlockedByAnyIngredient(ItemLike ... items) {
        this.advancement.addCriterion("has_any_ingredient", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items).build()}));
        return this;
    }

    public void build(RecipeOutput consumerIn) {
        KegCompatibleFluidIngredients.Tag tag;
        KegCompatibleFluidIngredients.Exact exact;
        AbstractedFluidIngredient baseFluidLocation;
        if (this.result == null) {
            throw new NullPointerException("Fermenting Recipe does not specify a result.");
        }
        if (this.result.right().isPresent()) {
            KegCompatibleFluidIngredients.Tag tag2;
            AbstractedFluidIngredient baseFluidLocation2;
            KegCompatibleFluidIngredients.Exact exact2;
            AbstractedFluidIngredient abstractedFluidIngredient;
            if (this.fluidIngredient.isPresent() && (abstractedFluidIngredient = this.fluidIngredient.get().ingredient()) instanceof KegCompatibleFluidIngredients.Exact && !(exact2 = (KegCompatibleFluidIngredients.Exact)abstractedFluidIngredient).displayStacks().isEmpty()) {
                baseFluidLocation2 = BuiltInRegistries.FLUID.getKey((Object)exact2.displayStacks().getFirst().fluid());
                ResourceLocation resultItemLocation = BuiltInRegistries.ITEM.getKey((Object)((ItemStack)this.result.right().get()).getItem());
                this.build(consumerIn, "brewinandchewin:fermenting/" + resultItemLocation.getPath() + "_from_" + baseFluidLocation2.getPath());
                return;
            }
            if (this.fluidIngredient.isPresent() && (baseFluidLocation2 = this.fluidIngredient.get().ingredient()) instanceof KegCompatibleFluidIngredients.Tag && (tag2 = (KegCompatibleFluidIngredients.Tag)baseFluidLocation2).getTagKey() != null) {
                baseFluidLocation2 = tag2.getTagKey().location();
                ResourceLocation resultItemLocation = BuiltInRegistries.ITEM.getKey((Object)((ItemStack)this.result.right().get()).getItem());
                this.build(consumerIn, "brewinandchewin:fermenting/" + resultItemLocation.getPath() + "_from_" + baseFluidLocation2.getPath());
                return;
            }
            ResourceLocation resultItemLocation = BuiltInRegistries.ITEM.getKey((Object)((ItemStack)this.result.right().get()).getItem());
            this.build(consumerIn, "brewinandchewin:fermenting/" + resultItemLocation.getPath());
            return;
        }
        if (this.fluidIngredient.isPresent() && (baseFluidLocation = this.fluidIngredient.get().ingredient()) instanceof KegCompatibleFluidIngredients.Exact && !(exact = (KegCompatibleFluidIngredients.Exact)baseFluidLocation).displayStacks().isEmpty()) {
            baseFluidLocation = BuiltInRegistries.FLUID.getKey((Object)exact.displayStacks().getFirst().fluid());
            ResourceLocation resultFluidLocation = BuiltInRegistries.FLUID.getKey((Object)((AbstractedFluidStack)this.result.left().get()).fluid());
            this.build(consumerIn, "brewinandchewin:fermenting/" + resultFluidLocation.getPath() + "_from_" + baseFluidLocation.getPath());
            return;
        }
        if (this.fluidIngredient.isPresent() && (baseFluidLocation = this.fluidIngredient.get().ingredient()) instanceof KegCompatibleFluidIngredients.Tag && (tag = (KegCompatibleFluidIngredients.Tag)baseFluidLocation).getTagKey() != null) {
            baseFluidLocation = tag.getTagKey().location();
            ResourceLocation resultFluidLocation = BuiltInRegistries.FLUID.getKey((Object)((AbstractedFluidStack)this.result.left().get()).fluid());
            this.build(consumerIn, "brewinandchewin:fermenting/" + resultFluidLocation.getPath() + "_from_" + baseFluidLocation.getPath());
            return;
        }
        ResourceLocation resultFluidLocation = BuiltInRegistries.FLUID.getKey((Object)((AbstractedFluidStack)this.result.left().get()).fluid());
        this.build(consumerIn, "brewinandchewin:fermenting/" + resultFluidLocation.getPath());
    }

    public void build(RecipeOutput consumerIn, String save) {
        if (this.result == null) {
            throw new NullPointerException("Fermenting Recipe " + save + " does not specify a result.");
        }
        ResourceLocation resourcelocation = (ResourceLocation)this.result.map(wrapper -> BuiltInRegistries.FLUID.getKey((Object)wrapper.fluid()), stack -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
        if (resourcelocation.equals((Object)ResourceLocation.tryParse((String)save))) {
            throw new IllegalStateException("Fermenting Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ResourceLocation.tryParse((String)save));
    }

    public KegFermentingRecipeBuilder addFluidIngredient(Fluid fluid, int i) {
        this.fluidIngredient = Optional.of(new FluidIngredientWithAmount(new KegCompatibleFluidIngredients.Exact(fluid), i, Optional.empty()));
        return this;
    }

    public KegFermentingRecipeBuilder addFluidIngredient(Fluid fluid, int i, FluidUnit unit) {
        this.fluidIngredient = Optional.of(new FluidIngredientWithAmount(new KegCompatibleFluidIngredients.Exact(fluid), i, Optional.of(unit)));
        return this;
    }

    public KegFermentingRecipeBuilder addFluidIngredient(TagKey<Fluid> fluid, int i) {
        this.fluidIngredient = Optional.of(new FluidIngredientWithAmount(new KegCompatibleFluidIngredients.Tag((HolderSet<Fluid>)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.FLUID.holderOwner(), fluid)), i, Optional.empty()));
        return this;
    }

    public KegFermentingRecipeBuilder addFluidIngredient(TagKey<Fluid> fluid, int i, FluidUnit unit) {
        this.fluidIngredient = Optional.of(new FluidIngredientWithAmount(new KegCompatibleFluidIngredients.Tag((HolderSet<Fluid>)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.FLUID.holderOwner(), fluid)), i, Optional.of(unit)));
        return this;
    }

    public KegFermentingRecipeBuilder addFluidIngredient(FluidIngredient ingredient, int i) {
        this.fluidIngredient = Optional.of(new FluidIngredientWithAmount(new KegCompatibleFluidIngredients.NeoForgeIngredient(ingredient), i, Optional.empty()));
        return this;
    }

    public void build(RecipeOutput consumerIn, ResourceLocation id) {
        ResourceLocation advancementId = id.withPath(path -> "recipes/" + path);
        AdvancementHolder builtAdvancement = this.advancement.build(advancementId);
        if (!builtAdvancement.value().criteria().isEmpty()) {
            this.advancement.parent(ResourceLocation.withDefaultNamespace((String)"recipes/root")).addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.advancement.rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id));
            builtAdvancement = this.advancement.build(advancementId);
        } else {
            builtAdvancement = null;
        }
        consumerIn.accept(id, (Recipe)new KegFermentingRecipe(this.ingredients, this.tab, this.fluidIngredient, this.unit, this.result, this.experience, this.fermentingTime, this.temperature), builtAdvancement);
    }
}

