/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.data.builder;

import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

public class BnCCookingPotRecipeBuilder {
    private CookingPotRecipeBookTab tab;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final ItemStack result;
    private final int cookingTime;
    private final float experience;
    private final ItemStack container;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();

    private BnCCookingPotRecipeBuilder(ItemLike resultIn, int count, int cookingTime, float experience, @Nullable ItemLike container) {
        this.result = new ItemStack(resultIn, count);
        this.cookingTime = cookingTime;
        this.experience = experience;
        this.container = container != null ? new ItemStack(container) : null;
        this.tab = null;
    }

    public static BnCCookingPotRecipeBuilder cookingPotRecipe(ItemLike mainResult, int count, int cookingTime, float experience) {
        return new BnCCookingPotRecipeBuilder(mainResult, count, cookingTime, experience, null);
    }

    public static BnCCookingPotRecipeBuilder cookingPotRecipe(ItemLike mainResult, int count, int cookingTime, float experience, ItemLike container) {
        return new BnCCookingPotRecipeBuilder(mainResult, count, cookingTime, experience, container);
    }

    public BnCCookingPotRecipeBuilder addIngredient(TagKey<Item> tagIn) {
        return this.addIngredient(Ingredient.of(tagIn));
    }

    public BnCCookingPotRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public BnCCookingPotRecipeBuilder addIngredient(ItemLike itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public BnCCookingPotRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public BnCCookingPotRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredientIn);
        }
        return this;
    }

    public BnCCookingPotRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.advancement.addCriterion(criterionName, criterionTrigger);
        return this;
    }

    public BnCCookingPotRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public BnCCookingPotRecipeBuilder unlockedByAnyIngredient(ItemLike ... items) {
        this.advancement.addCriterion("has_any_ingredient", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items).build()}));
        return this;
    }

    public BnCCookingPotRecipeBuilder setRecipeBookTab(CookingPotRecipeBookTab tab) {
        this.tab = tab;
        return this;
    }

    public void build(RecipeOutput output) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem());
        this.build(output, "brewinandchewin:cooking/" + location.getPath());
    }

    public void build(RecipeOutput output, String save) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem());
        if (location.equals((Object)ResourceLocation.tryParse((String)save))) {
            throw new IllegalStateException("Cooking Recipe " + save + " should remove its 'save' argument");
        }
        this.build(output, ResourceLocation.tryParse((String)save));
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        ResourceLocation advancementId = id.withPath(path -> "recipes/" + path);
        AdvancementHolder builtAdvancement = this.advancement.build(advancementId);
        if (!builtAdvancement.value().criteria().isEmpty()) {
            this.advancement.parent(ResourceLocation.withDefaultNamespace((String)"recipes/root")).addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.advancement.rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id));
            builtAdvancement = this.advancement.build(advancementId);
        } else {
            builtAdvancement = null;
        }
        output.accept(id, (Recipe)new CookingPotRecipe("", this.tab, this.ingredients, this.result, this.container, this.experience, this.cookingTime), builtAdvancement);
    }
}

