/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.clientbound;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.attachment.RagingAttachment;

public record SyncRagingStacksClientboundPacket(int entityId, Optional<Integer> stacks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BrewinAndChewin.asResource("sync_raging_stacks");
    public static final CustomPacketPayload.Type<SyncRagingStacksClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncRagingStacksClientboundPacket> STREAM_CODEC = StreamCodec.of(SyncRagingStacksClientboundPacket::encode, SyncRagingStacksClientboundPacket::new);

    public SyncRagingStacksClientboundPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readOptional(FriendlyByteBuf::readInt));
    }

    public static void encode(RegistryFriendlyByteBuf buf, SyncRagingStacksClientboundPacket packet) {
        buf.writeInt(packet.entityId());
        buf.writeOptional(packet.stacks(), FriendlyByteBuf::writeInt);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId());
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            BrewinAndChewin.getHelper().setRagingAttachment(living, this.stacks.map(i -> new RagingAttachment((int)i, 0)).orElse(null));
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

