/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.loot.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;

public class CopyDrinkFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyDrinkFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> CopyDrinkFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, CopyDrinkFunction::new));
    public static final ResourceLocation ID = BrewinAndChewin.asResource("copy_drink");
    public static final LootItemFunctionType<CopyDrinkFunction> TYPE = new LootItemFunctionType(CODEC);

    private CopyDrinkFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return CopyDrinkFunction.simpleBuilder(CopyDrinkFunction::new);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity tile = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof KegBlockEntity) {
            KegBlockEntity kegTile = (KegBlockEntity)tile;
            CompoundTag tag = kegTile.writeDrink(((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag(), (HolderLookup.Provider)context.getLevel().registryAccess());
            CustomData data = CustomData.of((CompoundTag)tag);
            if (!tag.isEmpty()) {
                stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)data);
            }
        }
        return stack;
    }

    public LootItemFunctionType<CopyDrinkFunction> getType() {
        return TYPE;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        Builder() {
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new CopyDrinkFunction(this.getConditions());
        }
    }
}

