/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.item;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import umpaz.brewinandchewin.client.gui.KegTooltip;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;

public class KegItem
extends BlockItem {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public KegItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return KegItem.getServingCount(stack) > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.min(1L + KegItem.getServingCount(stack) / 77L, 13L);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        AbstractedFluidStack mealStack = KegBlockEntity.getMealFromItem(stack, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        return Optional.of(new KegTooltip.KegTooltipComponent(mealStack));
    }

    private static long getServingCount(ItemStack stack) {
        CustomData nbt = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (nbt == null) {
            return 0L;
        }
        AbstractedFluidStack mealStack = KegBlockEntity.getMealFromItem(stack, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        return mealStack.amount();
    }
}

