/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.mixin.StackedContentsRecipePickerAccessor;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegStackedContents
extends StackedContents {
    public final KegMenu menu;
    public final RecipeManager recipeManager;
    private boolean ignoreItems = false;
    private boolean ignoreFluids = false;

    public KegStackedContents(KegMenu menu, RecipeManager manager) {
        this.menu = menu;
        this.recipeManager = manager;
    }

    public void setIgnoreItems(boolean value) {
        this.ignoreItems = value;
    }

    public void setIgnoreFluids(boolean value) {
        this.ignoreFluids = value;
    }

    public boolean shouldIgnoreItems() {
        return this.ignoreItems;
    }

    public boolean isFluidItem(Recipe<?> recipe, int itemIndex) {
        return new RecipePicker(recipe).isFluidItem(itemIndex);
    }

    public boolean canCraft(Recipe<?> recipe, @Nullable IntList stackingIndexList, int amount) {
        if (recipe instanceof KegFermentingRecipe) {
            KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
            if (!KegBlockEntity.isValidTemp(this.menu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                return false;
            }
        }
        return new RecipePicker(recipe).tryPick(amount, stackingIndexList);
    }

    public int getBiggestCraftableStack(RecipeHolder<?> recipe, int amount, @Nullable IntList stackingIndexList) {
        return new RecipePicker(recipe.value()).tryPickAll(amount, stackingIndexList);
    }

    public class RecipePicker
    extends StackedContents.RecipePicker {
        private final Int2IntMap stackCountRequirements;

        public RecipePicker(Recipe<?> recipe) {
            super((StackedContents)KegStackedContents.this, recipe);
            this.stackCountRequirements = new Int2IntArrayMap();
            if (recipe instanceof KegFermentingRecipe) {
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                boolean modified = false;
                AbstractedFluidTank kegTank = KegStackedContents.this.menu.kegTank;
                StackedContentsRecipePickerAccessor accessor = (StackedContentsRecipePickerAccessor)((Object)this);
                if (KegStackedContents.this.ignoreItems) {
                    accessor.brewinandchewin$getIngredients().clear();
                    modified = true;
                }
                if (!KegStackedContents.this.ignoreFluids) {
                    if (fermentingRecipe.getFluidIngredient().isEmpty() && !kegTank.isEmpty()) {
                        List<PouringEntry> fluidContainerStacks = KegStackedContents.this.recipeManager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().fluid().isSame(kegTank.getAbstractedFluid().fluid())).map(r -> new PouringEntry(r.getContainer(), r.getRawFluid().amount(), r.getUnit(), r.isStrict())).toList();
                        if (!fluidContainerStacks.isEmpty()) {
                            for (PouringEntry entry : fluidContainerStacks) {
                                int itemAmount = (int)(kegTank.getAbstractedFluid().amount() / entry.fluidUnit().convertToLoader(entry.fluidAmount()));
                                this.stackCountRequirements.put(StackedContents.getStackingIndex((ItemStack)entry.stack()), itemAmount);
                            }
                            Ingredient extractIngredient = Ingredient.of((ItemStack[])((ItemStack[])fluidContainerStacks.stream().map(PouringEntry::stack).toArray(ItemStack[]::new)));
                            extractIngredient.getItems();
                            extractIngredient.getStackingIds();
                            accessor.brewinandchewin$getIngredients().add(extractIngredient);
                            modified = true;
                        }
                    } else if (fermentingRecipe.getFluidIngredient().isPresent()) {
                        Object fluidContainerStacks;
                        List fluidOutputStacks = KegStackedContents.this.recipeManager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.canFill() && fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getRawFluid())).map(r -> new PouringEntry(r.getOutput(), r.getRawFluid().amount(), r.getUnit(), r.isStrict())).collect(Collectors.toCollection(ArrayList::new));
                        long tankAmount = kegTank.getAbstractedFluid().amount();
                        if (!(kegTank.isEmpty() || fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid()) || (fluidContainerStacks = KegStackedContents.this.recipeManager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().fluid().isSame(kegTank.getAbstractedFluid().fluid())).map(r -> new PouringEntry(r.getContainer(), r.getRawFluid().amount(), r.getUnit(), r.isStrict())).toList()).isEmpty())) {
                            Iterator iterator = fluidContainerStacks.iterator();
                            while (iterator.hasNext()) {
                                PouringEntry entry = (PouringEntry)iterator.next();
                                int itemAmount = (int)(kegTank.getAbstractedFluid().amount() / entry.fluidUnit().convertToLoader(entry.fluidAmount()));
                                tankAmount -= (long)itemAmount * entry.fluidUnit().convertToLoader(entry.fluidAmount());
                                this.stackCountRequirements.put(StackedContents.getStackingIndex((ItemStack)entry.stack()), itemAmount);
                            }
                            Ingredient extractIngredient = Ingredient.of((ItemStack[])((ItemStack[])fluidContainerStacks.stream().map(PouringEntry::stack).toArray(ItemStack[]::new)));
                            extractIngredient.getItems();
                            extractIngredient.getStackingIds();
                            accessor.brewinandchewin$getIngredients().add(extractIngredient);
                            modified = true;
                        }
                        if (kegTank.isEmpty() || !fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid()) || tankAmount < fermentingRecipe.getFluidIngredient().get().amount()) {
                            for (PouringEntry entry : List.copyOf(fluidOutputStacks)) {
                                int itemAmount = (int)(Math.max(fermentingRecipe.getFluidIngredient().get().loaderAmount(), entry.fluidUnit().convertToLoader(entry.fluidAmount()) - tankAmount) / entry.fluidUnit().convertToLoader(entry.fluidAmount()) - tankAmount % fermentingRecipe.getFluidIngredient().get().loaderAmount() / entry.fluidUnit().convertToLoader(entry.fluidAmount()));
                                if (itemAmount <= 0 || (long)itemAmount * entry.fluidUnit().convertToLoader(entry.fluidAmount()) + tankAmount > kegTank.getFluidCapacity()) {
                                    fluidOutputStacks.remove(entry);
                                    continue;
                                }
                                this.stackCountRequirements.put(StackedContents.getStackingIndex((ItemStack)entry.stack()), itemAmount);
                            }
                            if (!fluidOutputStacks.isEmpty()) {
                                Ingredient fillIngredient = Ingredient.of((ItemStack[])((ItemStack[])fluidOutputStacks.stream().map(PouringEntry::stack).toArray(ItemStack[]::new)));
                                if (fluidOutputStacks.stream().anyMatch(PouringEntry::strict)) {
                                    fillIngredient = BrewinAndChewin.getHelper().createStrictFillPickerIngredient(fluidOutputStacks);
                                }
                                fillIngredient.getItems();
                                fillIngredient.getStackingIds();
                                accessor.brewinandchewin$getIngredients().add(fillIngredient);
                                modified = true;
                            }
                        }
                    }
                }
                if (!modified) {
                    return;
                }
                accessor.brewinandchewin$getIngredients().removeIf(Ingredient::isEmpty);
                accessor.brewinandchewin$setIngredientCount(accessor.brewinandchewin$getIngredients().size());
                accessor.brewinandchewin$setItems(accessor.brewinandchewin$invokeGetUniqueAvailableIngredientItems());
                accessor.brewinandchewin$setItemCount(accessor.brewinandchewin$getItems().length);
                accessor.brewinandchewin$setData(new BitSet(accessor.brewinandchewin$getIngredientCount() + accessor.brewinandchewin$getItemCount() + accessor.brewinandchewin$getIngredientCount() + accessor.brewinandchewin$getIngredientCount() * accessor.brewinandchewin$getItemCount()));
                for (int i = 0; i < accessor.brewinandchewin$getIngredients().size(); ++i) {
                    IntList intlist = accessor.brewinandchewin$getIngredients().get(i).getStackingIds();
                    for (int j = 0; j < accessor.brewinandchewin$getItemCount(); ++j) {
                        if (!intlist.contains(accessor.brewinandchewin$getItems()[j])) continue;
                        int bitIndex = accessor.brewinandchewin$invokeGetIndex(true, j, i);
                        accessor.brewinandchewin$getData().set(bitIndex);
                    }
                }
            }
        }

        public boolean isFluidItem(int itemIndex) {
            return this.stackCountRequirements.containsKey(itemIndex);
        }

        public boolean hasFluidAmount(int originalAmount, int itemIndex) {
            return !this.isFluidItem(itemIndex) || originalAmount >= this.stackCountRequirements.get(itemIndex);
        }

        public KegStackedContents getOuter() {
            return KegStackedContents.this;
        }
    }

    public record PouringEntry(ItemStack stack, long fluidAmount, FluidUnit fluidUnit, boolean strict) {
    }
}

