/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.FluidItemComponentRemapper;
import umpaz.brewinandchewin.client.utility.IdentifiableListener;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;

public class BnCFluidItemDisplays {
    private static final Map<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack> FLUID_TYPE_TO_ITEM_MAP = new HashMap<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack>();

    public static ItemStack getFluidItemDisplay(HolderLookup.Provider lookup, AbstractedFluidStack fluid) {
        if (FLUID_TYPE_TO_ITEM_MAP.containsKey(Either.right((Object)fluid.fluid()))) {
            return FLUID_TYPE_TO_ITEM_MAP.get(Either.right((Object)fluid.fluid())).getStack(lookup, fluid);
        }
        Optional<Map.Entry> validTagKey = FLUID_TYPE_TO_ITEM_MAP.entrySet().stream().filter(entry -> (Boolean)((Either)entry.getKey()).map(fluidTagKey -> fluid.fluid().is(fluidTagKey), fluid1 -> false)).findFirst();
        if (validTagKey.isPresent()) {
            return ((FluidBasedItemStack)validTagKey.get().getValue()).getStack(lookup, fluid);
        }
        if (fluid.fluid().getBucket() != Items.AIR) {
            return fluid.fluid().getBucket().getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public record FluidBasedItemStack(Either<TagKey<Fluid>, Fluid> fluid, FluidItemComponentRemapper dataComponentRemapper) {
        private static final HashMap<Pair<Fluid, DataComponentMap>, ItemStack> CACHE = new HashMap(32);

        private static FluidBasedItemStack createFromJson(JsonElement json, Either<TagKey<Fluid>, Fluid> fluid) {
            return new FluidBasedItemStack(fluid, (FluidItemComponentRemapper)((Pair)FluidItemComponentRemapper.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst());
        }

        private ItemStack getStack(HolderLookup.Provider lookup, AbstractedFluidStack stack) {
            Pair pair = Pair.of((Object)stack.fluid(), (Object)stack.components());
            if (CACHE.containsKey(pair)) {
                return CACHE.get(pair);
            }
            ItemStack item = this.dataComponentRemapper.convert(lookup, stack);
            CACHE.put((Pair<Fluid, DataComponentMap>)pair, item);
            return item;
        }
    }

    public static class Loader
    extends SimplePreparableReloadListener<Map<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack>>
    implements IdentifiableListener {
        public static final Loader INSTANCE = new Loader();
        private static final Gson GSON = new GsonBuilder().create();

        protected Loader() {
        }

        protected Map<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)"brewinandchewin/fluid_item_displays");
            FluidBasedItemStack.CACHE.clear();
            HashMap<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack> map = new HashMap<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack>();
            for (Map.Entry entry : fileToIdConverter.listMatchingResourceStacks(resourceManager).entrySet()) {
                for (Resource resource : (List)entry.getValue()) {
                    try {
                        BufferedReader reader = resource.openAsReader();
                        try {
                            JsonObject jsonObject = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                            for (Map.Entry e : jsonObject.entrySet()) {
                                Either either;
                                boolean isCurrentOptional;
                                boolean bl = isCurrentOptional = ((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().has("optional") && ((JsonElement)e.getValue()).getAsJsonObject().get("optional").getAsBoolean();
                                if (((String)e.getKey()).startsWith("#")) {
                                    either = Either.left((Object)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)((String)e.getKey()).substring(1))));
                                } else {
                                    ResourceLocation fluidLocation = ResourceLocation.parse((String)((String)e.getKey()));
                                    if (!BuiltInRegistries.FLUID.containsKey(fluidLocation)) {
                                        if (isCurrentOptional) continue;
                                        BrewinAndChewin.LOG.error("Could not find fluid '{}' from fluid item display JSON at location '{}' from pack '{}'.", new Object[]{e.getKey(), entry.getKey(), resource.sourcePackId()});
                                        continue;
                                    }
                                    either = Either.right((Object)((Fluid)BuiltInRegistries.FLUID.get(fluidLocation)));
                                }
                                try {
                                    map.put((Either<TagKey<Fluid>, Fluid>)either, FluidBasedItemStack.createFromJson((JsonElement)e.getValue(), (Either<TagKey<Fluid>, Fluid>)either));
                                }
                                catch (JsonParseException | IllegalArgumentException | IllegalStateException | ResourceLocationException ex) {
                                    if (isCurrentOptional) continue;
                                    BrewinAndChewin.LOG.error("Couldn't parse fluid item display JSON at location '{}' from pack '{}'. ", new Object[]{entry.getKey(), resource.sourcePackId(), ex});
                                }
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException | IllegalStateException | ResourceLocationException ex) {
                        BrewinAndChewin.LOG.error("Couldn't parse fluid item display JSON at location '{}' from pack '{}'. ", new Object[]{entry.getKey(), resource.sourcePackId(), ex});
                    }
                }
            }
            return map;
        }

        protected void apply(Map<Either<TagKey<Fluid>, Fluid>, FluidBasedItemStack> obj, ResourceManager resourceManager, ProfilerFiller profiler) {
            FLUID_TYPE_TO_ITEM_MAP.putAll(obj);
        }

        @Override
        public ResourceLocation getId() {
            return BrewinAndChewin.asResource("coaster_models");
        }
    }
}

