/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.renderer.texture;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import umpaz.brewinandchewin.client.renderer.texture.modifier.GlintTextureModifier;
import umpaz.brewinandchewin.client.renderer.texture.modifier.GrassTintTextureModifier;
import umpaz.brewinandchewin.client.renderer.texture.modifier.PotionTintTextureModifier;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;

public class BnCTextureModifiers {
    private static final Map<ResourceLocation, MapCodec<? extends TextureModifier>> FACTORIES = new HashMap<ResourceLocation, MapCodec<? extends TextureModifier>>();
    private static final Map<MapCodec<? extends TextureModifier>, ResourceLocation> FACTORIES_TO_KEY = new HashMap<MapCodec<? extends TextureModifier>, ResourceLocation>();
    public static final Codec<? extends TextureModifier> CODEC = ResourceLocation.CODEC.comapFlatMap(key -> {
        if (!FACTORIES.containsKey(key)) {
            return DataResult.error(() -> "Could not find texture modifier type " + String.valueOf(key));
        }
        return DataResult.success(FACTORIES.get(key));
    }, FACTORIES_TO_KEY::get).dispatch(textureModifier -> textureModifier.codec(), mapCodec -> mapCodec);

    public static void register(ResourceLocation id, MapCodec<? extends TextureModifier> codec) {
        if (FACTORIES.containsKey(id)) {
            throw new UnsupportedOperationException("Attempted to register duplicate ID texture modifiers. " + String.valueOf(id));
        }
        FACTORIES.put(id, codec);
        FACTORIES_TO_KEY.put(codec, id);
    }

    public static void init() {
        BnCTextureModifiers.register(GlintTextureModifier.ID, GlintTextureModifier.CODEC);
        BnCTextureModifiers.register(GrassTintTextureModifier.ID, GrassTintTextureModifier.CODEC);
        BnCTextureModifiers.register(PotionTintTextureModifier.ID, PotionTintTextureModifier.CODEC);
    }
}

