/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import org.jetbrains.annotations.NotNull;
import umpaz.brewinandchewin.client.particle.DrunkBubbleParticleOptions;

public class DrunkBubbleParticle
extends TextureSheetParticle {
    protected DrunkBubbleParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(level, x, y, z);
        this.scale(2.0f);
        this.setSize(0.25f, 0.25f);
        this.lifetime = this.random.nextInt(50) + 30;
        this.gravity = 3.0E-6f;
        this.xd = motionX;
        this.yd = motionY + (double)(this.random.nextFloat() / 500.0f);
        this.zd = motionZ;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.xd += (double)(this.random.nextFloat() / 2500.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 2500.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.02f;
            }
        } else {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<DrunkBubbleParticleOptions> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(DrunkBubbleParticleOptions typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DrunkBubbleParticle particle = new DrunkBubbleParticle(level, x, y + 0.3, z, 0.0, 0.002, 0.0);
            particle.setAlpha(0.6f);
            particle.setColor(typeIn.getColor().x, typeIn.getColor().y, typeIn.getColor().z);
            particle.scale(typeIn.getScale());
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

