/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiFramebuffer;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShaderProgram;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeApplyShaderRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeBufferRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderCleanupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderPassEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderSetupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeTextureClearEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiTextureCreatedParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodBufferContainer;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.buffer.QuadElementBuffer;
import com.seibel.distanthorizons.core.render.glObject.texture.DHDepthTexture;
import com.seibel.distanthorizons.core.render.glObject.texture.DhColorTexture;
import com.seibel.distanthorizons.core.render.glObject.texture.DhFramebuffer;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhDepthBufferFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhInternalTextureFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelType;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.DhFadeRenderer;
import com.seibel.distanthorizons.core.render.renderer.DhTerrainShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.FogRenderer;
import com.seibel.distanthorizons.core.render.renderer.RenderParams;
import com.seibel.distanthorizons.core.render.renderer.SSAORenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.shaders.DhApplyShader;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.util.objects.SortedArraySet;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IIrisAccessor;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32;

public class LodRenderer {
    public static final DhLogger LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logRendererEventToFile).build();
    public static final DhLogger RATE_LIMITED_LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logRendererEventToFile).maxCountPerSecond(4).build();
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final IIrisAccessor IRIS_ACCESSOR = ModAccessorInjector.INSTANCE.get(IIrisAccessor.class);
    public static final LodRenderer INSTANCE = new LodRenderer();
    private int activeFramebufferId = -1;
    private int activeColorTextureId = -1;
    private int activeDepthTextureId = -1;
    private int textureWidth;
    private int textureHeight;
    private IDhApiShaderProgram lodRenderProgram = null;
    public QuadElementBuffer quadIBO = null;
    private boolean renderObjectsCreated = false;
    private IDhApiFramebuffer framebuffer;
    @Nullable
    private DhColorTexture nullableColorTexture;
    private DHDepthTexture depthTexture;
    private boolean usingMcFramebuffer = false;

    private LodRenderer() {
    }

    public void render(RenderParams renderParams, IProfilerWrapper profiler) {
        this.renderLodPass(renderParams, profiler, false);
    }

    public void renderDeferred(RenderParams renderParams, IProfilerWrapper profiler) {
        this.renderLodPass(renderParams, profiler, true);
    }

    private void renderLodPass(RenderParams renderParams, IProfilerWrapper profiler, boolean runningDeferredPass) {
        boolean firstPass;
        boolean deferTransparentRendering = DhApiRenderProxy.INSTANCE.getDeferTransparentRendering();
        if (runningDeferredPass && !deferTransparentRendering) {
            return;
        }
        boolean bl = firstPass = !runningDeferredPass;
        if (!renderParams.validationRun) {
            throw new IllegalArgumentException("Render parameters validation");
        }
        RenderBufferHandler renderBufferHandler = renderParams.renderBufferHandler;
        GenericObjectRenderer genericRenderer = renderParams.genericRenderer;
        ILightMapWrapper lightmap = renderParams.lightmap;
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderSetupEvent.class, renderParams);
        profiler.push("LOD GL setup");
        if (!this.renderObjectsCreated) {
            boolean setupSuccess = this.createRenderObjects();
            if (!setupSuccess) {
                return;
            }
            if (Config.Client.Advanced.Graphics.overrideVanillaGraphicsSettings.get().booleanValue()) {
                MC.disableVanillaClouds();
                MC.disableVanillaChunkFadeIn();
            }
            this.renderObjectsCreated = true;
        }
        this.setGLState(renderParams, firstPass);
        lightmap.bind();
        this.quadIBO.bind();
        if (firstPass) {
            profiler.popPush("LOD build render list");
            renderBufferHandler.buildRenderList(renderParams);
        }
        IDhApiShaderProgram lodShaderProgram = this.lodRenderProgram;
        IDhApiShaderProgram lodShaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiShaderProgram.class);
        if (lodShaderProgramOverride != null && lodShaderProgram.overrideThisFrame()) {
            lodShaderProgram = lodShaderProgramOverride;
        }
        if (!runningDeferredPass) {
            boolean cancelApplyShader;
            Mat4f combinedMatrix;
            profiler.popPush("LOD Opaque");
            this.renderLodPass(lodShaderProgram, renderBufferHandler, renderParams, true);
            if (Config.Client.Advanced.Graphics.GenericRendering.enableGenericRendering.get().booleanValue()) {
                profiler.popPush("Custom Objects");
                genericRenderer.render(renderParams, profiler, true);
            }
            if (Config.Client.Advanced.Graphics.Ssao.enableSsao.get().booleanValue()) {
                profiler.popPush("LOD SSAO");
                SSAORenderer.INSTANCE.render(new Mat4f(renderParams.dhProjectionMatrix), renderParams.partialTicks);
            }
            if (Config.Client.Advanced.Graphics.GenericRendering.enableGenericRendering.get().booleanValue()) {
                profiler.popPush("Custom Objects");
                genericRenderer.render(renderParams, profiler, false);
            }
            if (!deferTransparentRendering && Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled) {
                profiler.popPush("LOD Transparent");
                this.renderLodPass(lodShaderProgram, renderBufferHandler, renderParams, false);
            }
            if (Config.Client.Advanced.Graphics.Quality.dhFadeFarClipPlane.get().booleanValue() && (IRIS_ACCESSOR == null || !IRIS_ACCESSOR.isShaderPackInUse())) {
                profiler.popPush("Fade Far Clip Fade");
                DhFadeRenderer.INSTANCE.render(new Mat4f(renderParams.mcModelViewMatrix), new Mat4f(renderParams.mcProjectionMatrix), renderParams.partialTicks, profiler);
            }
            if (Config.Client.Advanced.Graphics.Fog.enableDhFog.get().booleanValue()) {
                profiler.popPush("LOD Fog");
                combinedMatrix = new Mat4f(renderParams.dhProjectionMatrix);
                combinedMatrix.multiply(renderParams.dhModelViewMatrix);
                FogRenderer.INSTANCE.render(combinedMatrix, renderParams.partialTicks);
            }
            if (Config.Client.Advanced.Debugging.DebugWireframe.enableRendering.get().booleanValue()) {
                profiler.popPush("Debug wireframes");
                combinedMatrix = new Mat4f(renderParams.dhProjectionMatrix);
                combinedMatrix.multiply(renderParams.dhModelViewMatrix);
                DebugRenderer.INSTANCE.render(combinedMatrix);
            }
            if (this.usingMcFramebuffer) {
                GL32.glClear((int)256);
            }
            if (!(cancelApplyShader = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeApplyShaderRenderEvent.class, renderParams))) {
                profiler.popPush("LOD Apply");
                DhApplyShader.INSTANCE.render(renderParams.partialTicks);
            }
        } else if (Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled) {
            profiler.popPush("LOD Transparent");
            this.renderLodPass(lodShaderProgram, renderBufferHandler, renderParams, false);
            if (Config.Client.Advanced.Graphics.Fog.enableDhFog.get().booleanValue()) {
                profiler.popPush("LOD Fog");
                Mat4f combinedMatrix = new Mat4f(renderParams.dhProjectionMatrix);
                combinedMatrix.multiply(renderParams.dhModelViewMatrix);
                FogRenderer.INSTANCE.render(combinedMatrix, renderParams.partialTicks);
            }
        }
        profiler.popPush("LOD cleanup");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderCleanupEvent.class, renderParams);
        lightmap.unbind();
        this.quadIBO.unbind();
        lodShaderProgram.unbind();
        profiler.pop();
    }

    private void setGLState(DhApiRenderParam renderEventParam, boolean firstPass) {
        boolean clearTextures;
        IDhApiFramebuffer framebuffer = this.framebuffer;
        IDhApiFramebuffer framebufferOverride = OverrideInjector.INSTANCE.get(IDhApiFramebuffer.class);
        if (framebufferOverride != null && framebufferOverride.overrideThisFrame()) {
            framebuffer = framebufferOverride;
        }
        this.activeFramebufferId = framebuffer.getId();
        framebuffer.bind();
        GL32.glPolygonMode((int)1032, (int)6914);
        GLMC.enableFaceCulling();
        GLMC.glBlendFunc(770, 771);
        GLMC.glBlendFuncSeparate(770, 771, 1, 0);
        GL32.glDisable((int)3089);
        GLMC.enableDepthTest();
        GLMC.glDepthFunc(513);
        GLMC.enableDepthMask();
        GL32.glViewport((int)0, (int)0, (int)this.textureWidth, (int)this.textureHeight);
        this.lodRenderProgram.bind();
        IDhApiShaderProgram shaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiShaderProgram.class);
        if (shaderProgramOverride != null) {
            shaderProgramOverride.fillUniformData(renderEventParam);
        }
        this.lodRenderProgram.fillUniformData(renderEventParam);
        if (MC_RENDER.getTargetFramebufferViewportWidth() != this.textureWidth || MC_RENDER.getTargetFramebufferViewportHeight() != this.textureHeight) {
            this.createAndBindTextures();
        }
        this.activeDepthTextureId = this.depthTexture.getTextureId();
        this.activeColorTextureId = this.nullableColorTexture != null ? this.nullableColorTexture.getTextureId() : GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36064, (int)36049);
        boolean bl = clearTextures = !ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeTextureClearEvent.class, renderEventParam);
        if (clearTextures) {
            GL32.glClearDepth((double)1.0);
            float[] clearColorValues = new float[4];
            GL32.glGetFloatv((int)3106, (float[])clearColorValues);
            GL32.glClearColor((float)clearColorValues[0], (float)clearColorValues[1], (float)clearColorValues[2], (float)1.0f);
            if (this.usingMcFramebuffer && framebufferOverride == null) {
                framebuffer.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F.isCombinedStencil());
                GL32.glClear((int)256);
            } else if (firstPass) {
                GL32.glClear((int)16640);
            }
        }
    }

    private boolean createRenderObjects() {
        if (this.renderObjectsCreated) {
            LOGGER.warn("Renderer setup called but it has already completed setup!", new Object[0]);
            return false;
        }
        if (!GLProxy.hasInstance()) {
            LOGGER.warn("Renderer setup called but GLProxy has not yet been setup!", new Object[0]);
            return false;
        }
        LOGGER.info("Setting up renderer", new Object[0]);
        this.lodRenderProgram = new DhTerrainShaderProgram();
        this.quadIBO = new QuadElementBuffer();
        this.quadIBO.reserve(LodBufferContainer.MAX_QUADS_PER_BUFFER);
        if (AbstractOptifineAccessor.optifinePresent()) {
            int currentFramebufferId = MC_RENDER.getTargetFramebuffer();
            this.framebuffer = new DhFramebuffer(currentFramebufferId);
            this.usingMcFramebuffer = true;
        } else {
            this.framebuffer = new DhFramebuffer();
            this.usingMcFramebuffer = false;
        }
        this.createAndBindTextures();
        if (this.framebuffer.getStatus() != 36053) {
            LOGGER.warn("Framebuffer [" + this.framebuffer.getId() + "] isn't complete.", new Object[0]);
            return false;
        }
        LOGGER.info("Renderer setup complete", new Object[0]);
        return true;
    }

    private void createAndBindTextures() {
        int oldWidth = this.textureWidth;
        int oldHeight = this.textureHeight;
        this.textureWidth = MC_RENDER.getTargetFramebufferViewportWidth();
        this.textureHeight = MC_RENDER.getTargetFramebufferViewportHeight();
        DhApiTextureCreatedParam textureCreatedParam = new DhApiTextureCreatedParam(oldWidth, oldHeight, this.textureWidth, this.textureHeight);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiColorDepthTextureCreatedEvent.class, new DhApiColorDepthTextureCreatedEvent.EventParam(textureCreatedParam));
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeColorDepthTextureCreatedEvent.class, textureCreatedParam);
        IDhApiFramebuffer framebufferOverride = OverrideInjector.INSTANCE.get(IDhApiFramebuffer.class);
        this.depthTexture = new DHDepthTexture(this.textureWidth, this.textureHeight, EDhDepthBufferFormat.DEPTH32F);
        this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F.isCombinedStencil());
        if (framebufferOverride != null) {
            framebufferOverride.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F.isCombinedStencil());
        }
        if (!this.usingMcFramebuffer) {
            this.nullableColorTexture = DhColorTexture.builder().setDimensions(this.textureWidth, this.textureHeight).setInternalFormat(EDhInternalTextureFormat.RGBA8).setPixelType(EDhPixelType.UNSIGNED_BYTE).setPixelFormat(EDhPixelFormat.RGBA).build();
            this.framebuffer.addColorAttachment(0, this.nullableColorTexture.getTextureId());
            if (framebufferOverride != null) {
                framebufferOverride.addColorAttachment(0, this.nullableColorTexture.getTextureId());
            }
        } else {
            this.nullableColorTexture = null;
        }
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterColorDepthTextureCreatedEvent.class, textureCreatedParam);
    }

    private void renderLodPass(IDhApiShaderProgram shaderProgram, RenderBufferHandler lodBufferHandler, RenderParams renderEventParam, boolean opaquePass) {
        SortedArraySet<LodBufferContainer> lodBufferContainer;
        boolean renderWireframe = Config.Client.Advanced.Debugging.renderWireframe.get();
        if (renderWireframe) {
            GL32.glPolygonMode((int)1032, (int)6913);
            GLMC.disableFaceCulling();
        } else {
            GL32.glPolygonMode((int)1032, (int)6914);
            GLMC.enableFaceCulling();
        }
        if (!opaquePass) {
            GLMC.enableBlend();
            GLMC.enableDepthTest();
            GL32.glBlendEquation((int)32774);
            GLMC.glBlendFuncSeparate(770, 771, 1, 771);
        } else {
            GLMC.disableBlend();
        }
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderPassEvent.class, renderEventParam);
        if (IRIS_ACCESSOR != null) {
            GLMC.enableFaceCulling();
        }
        if ((lodBufferContainer = lodBufferHandler.getColumnRenderBuffers()) != null) {
            for (int lodIndex = 0; lodIndex < lodBufferContainer.size(); ++lodIndex) {
                LodBufferContainer bufferContainer = lodBufferContainer.get(lodIndex);
                this.setShaderProgramMvmOffset(bufferContainer.minCornerBlockPos, shaderProgram, renderEventParam);
                GLVertexBuffer[] vbos = opaquePass ? bufferContainer.vbos : bufferContainer.vbosTransparent;
                for (int vboIndex = 0; vboIndex < vbos.length; ++vboIndex) {
                    GLVertexBuffer vbo = vbos[vboIndex];
                    if (vbo == null || vbo.getVertexCount() == 0) continue;
                    vbo.bind();
                    shaderProgram.bindVertexBuffer(vbo.getId());
                    GL32.glDrawElements((int)4, (int)(vbo.getVertexCount() / 4 * 6), (int)this.quadIBO.getType(), (long)0L);
                    vbo.unbind();
                }
            }
        }
        if (renderWireframe) {
            GL32.glPolygonMode((int)1032, (int)6914);
            GLMC.enableFaceCulling();
        }
    }

    private void setShaderProgramMvmOffset(DhBlockPos pos, IDhApiShaderProgram shaderProgram, RenderParams renderEventParam) throws IllegalStateException {
        Vec3d camPos = renderEventParam.exactCameraPosition;
        Vec3f modelPos = new Vec3f((float)((double)pos.getX() - camPos.x), (float)((double)pos.getY() - camPos.y), (float)((double)pos.getZ() - camPos.z));
        shaderProgram.bind();
        shaderProgram.setModelOffsetPos(modelPos);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeBufferRenderEvent.class, new DhApiBeforeBufferRenderEvent.EventParam(renderEventParam, modelPos));
    }

    public int getActiveFramebufferId() {
        return this.activeFramebufferId;
    }

    public int getActiveColorTextureId() {
        return this.activeColorTextureId;
    }

    public int getActiveDepthTextureId() {
        return this.activeDepthTextureId;
    }
}

