/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject;

import com.seibel.distanthorizons.api.enums.config.EDhApiGLErrorHandlingMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.EPlatform;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.GLMessages.EGLMessageSeverity;
import com.seibel.distanthorizons.core.util.objects.GLMessages.EGLMessageType;
import com.seibel.distanthorizons.core.util.objects.GLMessages.GLMessage;
import com.seibel.distanthorizons.core.util.objects.GLMessages.GLMessageBuilder;
import com.seibel.distanthorizons.core.util.objects.GLMessages.GLMessageOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;

public class GLProxy {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final DhLogger LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logRendererGLEventToFile).chatLevelConfig(Config.Common.Logging.logRendererGLEventToChat).build();
    public static final Set<String> LOGGED_GL_MESSAGES = Collections.newSetFromMap(new ConcurrentHashMap());
    private static GLProxy instance = null;
    private final ConcurrentLinkedQueue<Runnable> renderThreadRunnableQueue = new ConcurrentLinkedQueue();
    public final GLCapabilities glCapabilities;
    public boolean namedObjectSupported = false;
    public boolean bufferStorageSupported = false;
    public boolean vertexAttributeBufferBindingSupported = false;
    public boolean instancedArraysSupported = false;
    public boolean vertexAttribDivisorSupported = false;
    private final EDhApiGpuUploadMethod preferredUploadMethod;
    public final GLMessageBuilder vanillaDebugMessageBuilder = new GLMessageBuilder(type -> {
        if (type == EGLMessageType.POP_GROUP) {
            return false;
        }
        if (type == EGLMessageType.PUSH_GROUP) {
            return false;
        }
        if (type == EGLMessageType.MARKER) {
            return false;
        }
        return true;
    }, severity -> {
        if (severity == EGLMessageSeverity.NOTIFICATION) {
            return false;
        }
        return true;
    }, null);

    private GLProxy() throws IllegalStateException {
        if (GLFW.glfwGetCurrentContext() == 0L) {
            throw new IllegalStateException(GLProxy.class.getSimpleName() + " was created outside the render thread!");
        }
        LOGGER.info("Creating " + GLProxy.class.getSimpleName() + "... If this is the last message you see there must have been an OpenGL error.", new Object[0]);
        LOGGER.info("Lod Render OpenGL version [" + GL32.glGetString((int)7938) + "].", new Object[0]);
        this.glCapabilities = GL.getCapabilities();
        if (!this.glCapabilities.OpenGL32) {
            String supportedVersionInfo = this.getFailedVersionInfo(this.glCapabilities);
            String errorMessage = "Distant Horizons was initializing " + GLProxy.class.getSimpleName() + " and discovered this GPU doesn't meet the OpenGL requirements. Sorry I couldn't tell you sooner :(\nAdditional info:\n" + supportedVersionInfo;
            MC.crashMinecraft(errorMessage, new UnsupportedOperationException("Distant Horizon OpenGL requirements not met"));
        }
        LOGGER.info("minecraftGlCapabilities:\n" + this.versionInfoToString(this.glCapabilities), new Object[0]);
        if (Config.Client.Advanced.Debugging.OpenGl.overrideVanillaGLLogger.get().booleanValue()) {
            GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.vanillaDebugMessageBuilder), true));
        }
        this.namedObjectSupported = this.glCapabilities.glNamedBufferData != 0L;
        boolean bl = this.bufferStorageSupported = this.glCapabilities.glBufferStorage != 0L;
        if (!this.bufferStorageSupported) {
            LOGGER.info("This GPU doesn't support Buffer Storage (OpenGL 4.4), falling back to using other methods.", new Object[0]);
        }
        this.vertexAttributeBufferBindingSupported = this.glCapabilities.glBindVertexBuffer != 0L;
        this.vertexAttribDivisorSupported = this.glCapabilities.OpenGL33;
        this.instancedArraysSupported = this.glCapabilities.GL_ARB_instanced_arrays;
        String vendor = GL32.glGetString((int)7936).toUpperCase();
        this.preferredUploadMethod = EPlatform.get() != EPlatform.MACOS ? (vendor.contains("NVIDIA") || vendor.contains("GEFORCE") ? (this.bufferStorageSupported ? EDhApiGpuUploadMethod.BUFFER_STORAGE : EDhApiGpuUploadMethod.SUB_DATA) : (this.bufferStorageSupported ? EDhApiGpuUploadMethod.BUFFER_STORAGE : EDhApiGpuUploadMethod.DATA)) : EDhApiGpuUploadMethod.DATA;
        LOGGER.info("GPU Vendor [" + vendor + "] with OS [" + EPlatform.get().getName() + "], Preferred upload method is [" + (Object)((Object)this.preferredUploadMethod) + "].", new Object[0]);
        LOGGER.info(GLProxy.class.getSimpleName() + " creation successful. OpenGL smiles upon you this day.", new Object[0]);
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static GLProxy getInstance() throws IllegalStateException {
        if (instance == null) {
            instance = new GLProxy();
        }
        return instance;
    }

    public EDhApiGpuUploadMethod getGpuUploadMethod() {
        EDhApiGpuUploadMethod uploadOverride = Config.Client.Advanced.Debugging.OpenGl.glUploadMode.get();
        if (uploadOverride == EDhApiGpuUploadMethod.AUTO) {
            return this.preferredUploadMethod;
        }
        return uploadOverride;
    }

    public boolean runningOnRenderThread() {
        long currentContext = GLFW.glfwGetCurrentContext();
        return currentContext != 0L;
    }

    public void queueRunningOnRenderThread(Runnable renderCall) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.renderThreadRunnableQueue.add(() -> this.runOpenGlCall(renderCall, stackTrace));
    }

    private void runOpenGlCall(Runnable renderCall, StackTraceElement[] stackTrace) {
        try {
            renderCall.run();
        }
        catch (Exception e) {
            RuntimeException error = new RuntimeException("Uncaught Exception during GL call execution:", e);
            error.setStackTrace(stackTrace);
            LOGGER.error("[" + Thread.currentThread().getName() + "] ran into an unexpected error running a GL call, Error: [" + e.getMessage() + "].", error);
        }
    }

    public void runRenderThreadTasks() {
        long startTime = System.nanoTime();
        Runnable runnable = this.renderThreadRunnableQueue.poll();
        while (runnable != null) {
            runnable.run();
            long currentTime = System.nanoTime();
            long runDuration = currentTime - startTime;
            if (runDuration > 4000000L) break;
            runnable = this.renderThreadRunnableQueue.poll();
        }
    }

    private static void logMessage(GLMessage msg) {
        EDhApiGLErrorHandlingMode errorHandlingMode = Config.Client.Advanced.Debugging.OpenGl.glErrorHandlingMode.get();
        if (errorHandlingMode == EDhApiGLErrorHandlingMode.IGNORE) {
            return;
        }
        boolean onlyLogOnce = Config.Client.Advanced.Debugging.OpenGl.onlyLogGlErrorsOnce.get();
        String errorMessage = "GL ERROR [" + msg.id + "] from [" + (Object)((Object)msg.source) + "]: [" + msg.message + "]" + (onlyLogOnce ? " this message will only be logged once" : "") + ".";
        if (onlyLogOnce && !LOGGED_GL_MESSAGES.add(errorMessage)) {
            return;
        }
        RuntimeException exception = new RuntimeException(errorMessage);
        if (msg.type == EGLMessageType.ERROR || msg.type == EGLMessageType.UNDEFINED_BEHAVIOR) {
            LOGGER.error(exception.getMessage(), exception);
            if (errorHandlingMode == EDhApiGLErrorHandlingMode.LOG_THROW) {
                throw exception;
            }
        } else {
            EGLMessageSeverity severity = msg.severity;
            if (severity == null) {
                severity = EGLMessageSeverity.LOW;
            }
            switch (severity) {
                case HIGH: {
                    LOGGER.error(exception.getMessage(), exception);
                    break;
                }
                case MEDIUM: {
                    LOGGER.warn(exception.getMessage(), exception);
                    break;
                }
                case LOW: {
                    LOGGER.info(exception.getMessage(), exception);
                    break;
                }
                case NOTIFICATION: {
                    LOGGER.debug(exception.getMessage(), exception);
                }
            }
        }
    }

    private String getFailedVersionInfo(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: [" + c.OpenGL32 + "] <- REQUIRED\nVertex Attribute Buffer Binding: [" + (c.glVertexAttribBinding != 0L) + "] <- optional improvement\nBuffer Storage: [" + (c.glBufferStorage != 0L) + "] <- optional improvement\nIf you noticed that your computer supports higher OpenGL versions but not the required version, try running the game in compatibility mode. (How you turn that on, I have no clue~)";
    }

    private String versionInfoToString(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: [" + c.OpenGL32 + "] <- REQUIRED\nVertex Attribute Buffer Binding: [" + (c.glVertexAttribBinding != 0L) + "] <- optional improvement\nBuffer Storage: [" + (c.glBufferStorage != 0L) + "] <- optional improvement\n";
    }
}

