/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal.chunkUpdating;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkPosQueue;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkUpdateData;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ChunkUpdateQueueManager {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public final ChunkPosQueue updateQueue;
    public final ChunkPosQueue preUpdateQueue;
    public final Set<DhChunkPos> ignoredChunkPosSet = Collections.newSetFromMap(new ConcurrentHashMap());
    public int maxSize = 500;
    private static long lastOverloadedLogMessageMsTime = 0L;

    public ChunkUpdateQueueManager() {
        this.updateQueue = new ChunkPosQueue();
        this.preUpdateQueue = new ChunkPosQueue();
    }

    public boolean contains(DhChunkPos pos) {
        return this.updateQueue.contains(pos) || this.ignoredChunkPosSet.contains(pos) || this.preUpdateQueue.contains(pos);
    }

    public void clear() {
        this.updateQueue.clear();
        this.preUpdateQueue.clear();
        this.ignoredChunkPosSet.clear();
    }

    public int getQueuedCount() {
        return this.updateQueue.getQueuedCount() + this.preUpdateQueue.getQueuedCount();
    }

    public boolean isEmpty() {
        return this.updateQueue.isEmpty() && this.preUpdateQueue.isEmpty();
    }

    public void addItemToPreUpdateQueue(DhChunkPos pos, ChunkUpdateData updateData) {
        int remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            if (!this.updateQueue.isEmpty()) {
                this.updateQueue.popFurthest();
            } else {
                this.preUpdateQueue.popFurthest();
            }
        }
        this.preUpdateQueue.addItem(pos, updateData);
        remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.sendOverloadMessage();
        }
    }

    public void addItemToUpdateQueue(DhChunkPos pos, ChunkUpdateData updateData) {
        int remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.updateQueue.popFurthest();
        }
        this.updateQueue.addItem(pos, updateData);
        remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.sendOverloadMessage();
        }
    }

    private void sendOverloadMessage() {
        long msBetweenLastLog = System.currentTimeMillis() - lastOverloadedLogMessageMsTime;
        if (msBetweenLastLog >= 30000L) {
            lastOverloadedLogMessageMsTime = System.currentTimeMillis();
            String message = "\u00a76Distant Horizons overloaded, too many chunks queued for LOD processing. \u00a7r\nThis may result in holes in your LODs. \nFix: move through the world slower, decrease your vanilla render distance, slow down your world pre-generator (IE Chunky), or increase the Distant Horizons' CPU thread counts. \nMax queue count [" + SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.maxSize + "] ([" + 1000 + "] per thread+players).";
            boolean showWarningInChat = Config.Common.Logging.Warning.showUpdateQueueOverloadedChatWarning.get();
            if (showWarningInChat) {
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            EWorldEnvironment environment = SharedApi.getEnvironment();
            if (showWarningInChat || environment == EWorldEnvironment.SERVER_ONLY) {
                LOGGER.warn(message, new Object[0]);
            }
        }
    }

    public void addPosToIgnore(DhChunkPos chunkPos) {
        this.ignoredChunkPosSet.add(chunkPos);
    }

    public void removePosToIgnore(DhChunkPos chunkPos) {
        this.ignoredChunkPosSet.remove(chunkPos);
    }

    public void setCenter(DhChunkPos newCenter) {
        this.updateQueue.setCenter(newCenter);
        this.preUpdateQueue.setCenter(newCenter);
    }
}

