/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.worldgen;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.worldgen.TFMGPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class TFMGBiomeModifiers {
    public static final ResourceKey<BiomeModifier> OIL_DEPOSIT = TFMGBiomeModifiers.key("oil_deposit");
    public static final ResourceKey<BiomeModifier> OIL_WELL = TFMGBiomeModifiers.key("oil_well");
    public static final ResourceKey<BiomeModifier> LEAD_ORE = TFMGBiomeModifiers.key("lead_ore");
    public static final ResourceKey<BiomeModifier> NICKEL_ORE = TFMGBiomeModifiers.key("nickel_ore");
    public static final ResourceKey<BiomeModifier> LITHIUM_ORE = TFMGBiomeModifiers.key("lithium_ore");
    public static final ResourceKey<BiomeModifier> TFMG_STRIATED_ORES_OVERWORLD = TFMGBiomeModifiers.key("tfmg_striated_ores_overworld");
    public static final ResourceKey<BiomeModifier> TFMG_STRIATED_ORES_NETHER = TFMGBiomeModifiers.key("tfmg_striated_ores_nether");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)TFMG.asResource(name));
    }

    public static void bootstrap(BootstrapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.lookup(Registries.BIOME);
        HolderSet.Named isOverworld = biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderSet.Named isNether = biomeLookup.getOrThrow(BiomeTags.IS_NETHER);
        HolderSet.Named isDesert = biomeLookup.getOrThrow(BiomeTags.HAS_DESERT_PYRAMID);
        HolderGetter featureLookup = ctx.lookup(Registries.PLACED_FEATURE);
        Holder.Reference oilDeposit = featureLookup.getOrThrow(TFMGPlacedFeatures.OIL_DEPOSIT);
        Holder.Reference oilWell = featureLookup.getOrThrow(TFMGPlacedFeatures.OIL_WELL);
        Holder.Reference leadOre = featureLookup.getOrThrow(TFMGPlacedFeatures.LEAD_ORE);
        Holder.Reference nickelOre = featureLookup.getOrThrow(TFMGPlacedFeatures.NICKEL_ORE);
        Holder.Reference lithiumOre = featureLookup.getOrThrow(TFMGPlacedFeatures.LITHIUM_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.getOrThrow(TFMGPlacedFeatures.TFMG_STRIATED_ORES_OVERWORLD);
        Holder.Reference striatedOresNether = featureLookup.getOrThrow(TFMGPlacedFeatures.TFMG_STRIATED_ORES_NETHER);
        ctx.register(OIL_DEPOSIT, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)oilDeposit));
        ctx.register(OIL_WELL, (Object)TFMGBiomeModifiers.addOilWell((HolderSet<Biome>)isDesert, (Holder<PlacedFeature>)oilWell));
        ctx.register(LEAD_ORE, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)leadOre));
        ctx.register(NICKEL_ORE, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)nickelOre));
        ctx.register(LITHIUM_ORE, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)lithiumOre));
        ctx.register(TFMG_STRIATED_ORES_OVERWORLD, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striatedOresOverworld));
        ctx.register(TFMG_STRIATED_ORES_NETHER, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isNether, (Holder<PlacedFeature>)striatedOresNether));
    }

    private static BiomeModifiers.AddFeaturesBiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }

    private static BiomeModifiers.AddFeaturesBiomeModifier addOilWell(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{feature}), GenerationStep.Decoration.FLUID_SPRINGS);
    }
}

