/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.measurement;

import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.measurement.MultimeterItem;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.Map;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MultimeterOverlayRenderer {
    public static final LayeredDraw.Layer OVERLAY = MultimeterOverlayRenderer::renderOverlay;
    private static final Map<Object, Outliner.OutlineEntry> outlines = Outliner.getInstance().getOutlines();
    public static int hoverTicks = 0;
    public static BlockPos lastHovered = null;

    public static void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.hitResult;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        ClientLevel world = mc.level;
        BlockPos pos = result.getBlockPos();
        int prevHoverTicks = hoverTicks++;
        lastHovered = pos;
        pos = MultimeterOverlayRenderer.proxiedOverlayPosition((Level)world, pos);
        BlockEntity be = world.getBlockEntity(pos);
        boolean holdsMultimeter = MultimeterItem.isHeldByPlayer((Player)mc.player);
        boolean isShifting = mc.player.isShiftKeyDown();
        boolean isElectricBlock = be instanceof IElectric;
        if (!isElectricBlock) {
            return;
        }
        ItemStack item = TFMGItems.MULTIMETER.asStack();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)TFMGLang.number(1.0).component());
        ((IElectric)be).makeMultimeterTooltip(tooltip, isShifting);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        CClient cClient = AllConfigs.client();
        int posX = width / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.clamp((float)(((float)hoverTicks + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color(((Integer)cClient.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = new Color(1356585748);
        Color colorBorderBot = new Color(1354611983);
        if (fade < 1.0f) {
            poseStack.translate(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        GuiGameElement.of((ItemStack)item).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(graphics);
        if (!Mods.MODERNUI.isLoaded()) {
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
            poseStack.popPose();
            return;
        }
        MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
        Window window = Minecraft.getInstance().getWindow();
        double guiScale = window.getGuiScale();
        double cursorX = mouseHandler.xpos();
        double cursorY = mouseHandler.ypos();
        ((MouseHandlerAccessor)mouseHandler).create$setXPos((double)Math.round(cursorX / guiScale) * guiScale);
        ((MouseHandlerAccessor)mouseHandler).create$setYPos((double)Math.round(cursorY / guiScale) * guiScale);
        RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
        ((MouseHandlerAccessor)mouseHandler).create$setXPos(cursorX);
        ((MouseHandlerAccessor)mouseHandler).create$setYPos(cursorY);
        poseStack.popPose();
    }

    public static BlockPos proxiedOverlayPosition(Level level, BlockPos pos) {
        BlockState targetedState = level.getBlockState(pos);
        Block block = targetedState.getBlock();
        if (block instanceof IProxyHoveringInformation) {
            IProxyHoveringInformation proxy = (IProxyHoveringInformation)block;
            return proxy.getInformationSource(level, pos, targetedState);
        }
        return pos;
    }
}

