/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.cables;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlock;
import com.drmangotea.tfmg.content.electricity.connection.cables.CablePos;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.SpoolItem;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CableConnectorBlockEntity
extends ElectricBlockEntity
implements IHaveHoveringInformation {
    public Player player;
    public int color = 0;
    public LerpedFloat wireMovementX = LerpedFloat.linear();
    public LerpedFloat wireMovementY = LerpedFloat.linear();
    public LerpedFloat wireMovementZ = LerpedFloat.linear();
    public List<CableConnection> connections = new ArrayList<CableConnection>();
    public long id;
    public boolean removeWiresNextTick = false;

    public CableConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.wireMovementX.setValue((double)pos.getX());
        this.wireMovementY.setValue((double)pos.getY());
        this.wireMovementZ.setValue((double)pos.getZ());
        this.id = this.getBlockPos().asLong();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public void remove() {
        super.remove();
        this.notifyRemoval();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        if (((Boolean)this.getBlockState().getValue((Property)CableConnectorBlock.EXTENSION)).booleanValue()) {
            return direction.getAxis() == ((Direction)this.getBlockState().getValue((Property)WallMountBlock.FACING)).getAxis();
        }
        return direction == ((Direction)this.getBlockState().getValue((Property)WallMountBlock.FACING)).getOpposite();
    }

    public void notifyRemoval() {
        if (this.level.isClientSide) {
            return;
        }
        for (CableConnection connection : this.connections) {
            CableConnectorBlockEntity be;
            BlockPos pos;
            BlockEntity blockEntity;
            ItemEntity itemToDrop = new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), new ItemStack((ItemLike)connection.type.getWire().asItem(), (int)(connection.getLength() / 8.0f)));
            if (itemToDrop.getItem().getCount() > 0) {
                this.level.addFreshEntity((Entity)itemToDrop);
            }
            if (!((blockEntity = this.level.getBlockEntity(pos = connection.blockPos1)) instanceof CableConnectorBlockEntity) || (be = (CableConnectorBlockEntity)blockEntity).getBlockPos() == this.getBlockPos()) continue;
            be.onPlaced();
            be.removeWiresNextTick = true;
        }
    }

    public void removeConnection() {
        this.connections.removeIf(c -> {
            BlockPos pos = c.blockPos1;
            return !(this.level.getBlockEntity(pos) instanceof CableConnectorBlockEntity);
        });
        this.sendStuff();
    }

    @Override
    public void onConnected() {
        super.onConnected();
        for (CableConnectorBlockEntity be : this.getConnectedWires()) {
            if (be.getData().getId() != this.getData().getId()) {
                be.setNetwork(this.getData().getId());
                be.onConnected();
            }
            be.sendStuff();
        }
        this.sendStuff();
    }

    public List<CableConnectorBlockEntity> getConnectedWires() {
        return this.getConnectedWires(new ArrayList<CableConnectorBlockEntity>());
    }

    public List<CableConnectorBlockEntity> getConnectedWires(List<CableConnectorBlockEntity> foundList) {
        if (!foundList.contains(this)) {
            foundList.add(this);
        }
        for (CableConnection connection : this.connections) {
            CableConnectorBlockEntity be;
            BlockEntity blockEntity;
            BlockPos pos = connection.blockPos1;
            if (pos == this.getBlockPos() || !((blockEntity = this.level.getBlockEntity(pos)) instanceof CableConnectorBlockEntity) || foundList.contains(be = (CableConnectorBlockEntity)blockEntity)) continue;
            be.getConnectedWires(foundList);
            this.sendStuff();
            be.sendStuff();
        }
        this.sendStuff();
        return foundList;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.removeWiresNextTick) {
            this.removeConnection();
            this.removeWiresNextTick = false;
        }
        if (this.player != null) {
            this.managePlayerWire();
        }
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("ConnectionCount", this.connections.size());
        for (int i = 0; i < this.connections.size(); ++i) {
            CableConnection connection = this.connections.get(i);
            compound.put("Connection" + i, (Tag)connection.saveConnection());
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.connections = new ArrayList<CableConnection>();
        for (int i = 0; i < compound.getInt("ConnectionCount"); ++i) {
            this.connections.add(CableConnection.loadConnection(compound.getCompound("Connection" + i)));
        }
    }

    public void managePlayerWire() {
        this.wireMovementX.chase(this.player.getX() - 0.5, 0.7, LerpedFloat.Chaser.EXP);
        this.wireMovementY.chase(this.player.getY() + (this.player.isCrouching() ? 0.6 : 0.9), 0.3, LerpedFloat.Chaser.EXP);
        this.wireMovementZ.chase(this.player.getZ() - 0.5, 0.7, LerpedFloat.Chaser.EXP);
        this.wireMovementX.tickChaser();
        this.wireMovementY.tickChaser();
        this.wireMovementZ.tickChaser();
    }

    public CablePos getCablePosition() {
        return new CablePos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ());
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(32.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickOutliner() {
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        ClientLevel level = mc.level;
        BlockPos pos = result.getBlockPos();
        LocalPlayer player = mc.player;
        ItemStack heldItem = player.getMainHandItem();
        if (!(level.getBlockState(pos).getBlock() instanceof CableConnectorBlock)) {
            return;
        }
        if (!(heldItem.getItem() instanceof SpoolItem)) {
            return;
        }
        Direction direction = (Direction)level.getBlockState(pos).getValue((Property)WallMountBlock.FACING);
        for (int i = 0; i < 64 && level.getBlockEntity(pos.relative(direction)) instanceof CableConnectorBlockEntity; ++i) {
            pos = pos.relative(direction);
        }
        int length = 0;
        for (int i = 0; i < 64 && level.getBlockEntity(pos.relative(direction.getOpposite(), i + 1)) instanceof CableConnectorBlockEntity; ++i) {
            ++length;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        ArrayList<Direction.Axis> axis = new ArrayList<Direction.Axis>(Arrays.stream(Direction.Axis.values()).toList());
        axis.remove(direction.getAxis());
        float size = TFMGBlocks.CABLE_CONNECTOR.has(level.getBlockState(pos)) ? 2.5f : 3.5f;
        Vec3 corner1 = center.relative(direction, 0.0625).relative(direction.getClockWise((Direction.Axis)axis.get(0)), (double)(size / 15.0f)).relative(direction.getClockWise((Direction.Axis)axis.get(1)), (double)(size / 15.0f));
        Vec3 corner2 = center.relative(direction.getOpposite(), (double)(0.5f + (float)length)).relative(direction.getCounterClockWise((Direction.Axis)axis.get(0)), (double)(size / 15.0f)).relative(direction.getCounterClockWise((Direction.Axis)axis.get(1)), (double)(size / 15.0f));
        TFMGUtils.createOutline(corner1, corner2, "InsulatorOutline", Color.rainbowColor((int)(AnimationTickHolder.getTicks() * 5)));
    }
}

