/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration;

import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LithiumTorchBlock
extends WallMountBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5), (Object)Direction.UP, (Object)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (Object)Direction.DOWN, (Object)Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)));

    public LithiumTorchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE.get(pState.getValue((Property)FACING));
    }

    public FluidState getFluidState(BlockState p_51475_) {
        return (Boolean)p_51475_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_51475_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55125_) {
        p_55125_.add(new Property[]{WATERLOGGED, FACING});
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        double d0 = (double)pPos.getX() + 0.5;
        double d1 = (double)pPos.getY() + 0.7;
        double d2 = (double)pPos.getZ() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        Direction direction1 = direction.getOpposite();
        double y = direction == Direction.DOWN ? d1 - 0.22 * (double)direction1.getStepY() : d1 + 0.11;
        pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.27 * (double)direction1.getStepX(), y, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
        pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + 0.27 * (double)direction1.getStepX(), y, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, direction);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }
}

