/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MilkshakeItem
extends Item {
    public MilkshakeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack result = super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.getAbilities().instabuild) {
                if (result.isEmpty()) {
                    return Items.GLASS_BOTTLE.getDefaultInstance();
                }
                player.getInventory().add(Items.GLASS_BOTTLE.getDefaultInstance());
            }
        }
        return result;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 21;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }
}

