/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.logistics.fluid_gauge;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.lopyluna.dndesires.content.blocks.logistics.fluid_gauge.FluidGaugeBlock;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidGaugeBE
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public LerpedFloat target = LerpedFloat.linear();
    public IFluidHandler targetInv = null;

    public FluidGaugeBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(1);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        this.target.tickChaser();
    }

    public void lazyTick() {
        if (this.level == null) {
            this.targetInv = null;
            this.target.chase(0.0, 0.125, LerpedFloat.Chaser.EXP);
            return;
        }
        if (this.targetInv != null) {
            int capacity = this.targetInv.getTankCapacity(0);
            FluidStack fluid = this.targetInv.getFluidInTank(0);
            int amount = fluid.getAmount();
            float targetAmount = (float)amount / (float)capacity;
            this.target.chase((double)targetAmount, 0.125, LerpedFloat.Chaser.EXP);
        } else {
            this.target.chase(0.0, 0.125, LerpedFloat.Chaser.EXP);
        }
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)FluidGaugeBlock.FACING);
        BlockPos blockPos = pos.relative(facing);
        BlockEntity be = this.level.getBlockEntity(blockPos);
        if (be == null) {
            this.targetInv = null;
            return;
        }
        this.targetInv = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos, (Object)facing);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean result = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.targetInv == null) {
            return result;
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.targetInv);
        return result;
    }
}

