/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan.IAirCurrentIndustrialSource;
import dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan.IndustrialAirCurrent;
import dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan.IndustrialFanBlock;
import dev.lopyluna.dndesires.register.DesiresBlocks;
import dev.lopyluna.dndesires.register.DesiresConfigs;
import dev.lopyluna.dndesires.register.DesiresTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndustrialFanBE
extends GeneratingKineticBlockEntity
implements IAirCurrentIndustrialSource {
    protected boolean isGenerator = false;
    protected boolean updateGenerator = false;
    public IndustrialAirCurrent airCurrent = new IndustrialAirCurrent(this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;

    public IndustrialFanBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.ENCASED_FAN, AllAdvancements.FAN_PROCESSING});
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (!this.wasMoved) {
            this.isGenerator = compound.getBoolean("Generating");
        }
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Generating", this.isGenerator);
        super.write(compound, registries, clientPacket);
    }

    public float calculateAddedStressCapacity() {
        return this.isGenerator ? super.calculateAddedStressCapacity() : 0.0f;
    }

    public float calculateStressApplied() {
        return this.isGenerator ? 0.0f : super.calculateStressApplied();
    }

    public float getGeneratedSpeed() {
        return this.isGenerator ? 64.0f : 0.0f;
    }

    public void queueGeneratorUpdate() {
        this.updateGenerator = true;
    }

    public void updateGenerator() {
        BlockState blockState = this.getBlockState();
        boolean shouldGenerate = DesiresBlocks.INDUSTRIAL_FAN.has(blockState);
        if (shouldGenerate && blockState.getValue((Property)IndustrialFanBlock.FACING) != Direction.DOWN && !this.blockBelowIsHot()) {
            shouldGenerate = false;
        }
        if (shouldGenerate) {
            boolean bl = shouldGenerate = this.level != null && this.blockBelowIsHot() && (this.level.hasSignal(this.worldPosition, Direction.DOWN) || this.level.hasNeighborSignal(this.worldPosition.below())) && blockState.getValue((Property)IndustrialFanBlock.FACING) == Direction.DOWN;
        }
        if (shouldGenerate == this.isGenerator) {
            return;
        }
        this.isGenerator = shouldGenerate;
        this.updateGeneratedRotation();
    }

    public boolean blockBelowIsHot() {
        assert (this.level != null);
        FluidState fluidState = this.level.getFluidState(this.worldPosition.below());
        if (DesiresTags.FluidTags.INDUSTRIAL_FAN_HEATER.is(fluidState)) {
            return true;
        }
        BlockState blockState = this.level.getBlockState(this.worldPosition.below());
        if (DesiresTags.BlockTags.INDUSTRIAL_FAN_HEATER.is(blockState)) {
            return !blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        }
        return false;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.level;
    }

    @NotNull
    public BlockPos getAirCurrentPos() {
        return this.worldPosition;
    }

    @NotNull
    public Direction getAirflowOriginSide() {
        return (Direction)this.getBlockState().getValue((Property)IndustrialFanBlock.FACING);
    }

    @Nullable
    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        return (speed = IndustrialFanBE.convertToDirection((float)speed, (Direction)facing)) > 0.0f ? facing : facing.getOpposite();
    }

    public void remove() {
        super.remove();
        this.updateChute();
    }

    public boolean isSourceRemoved() {
        return this.remove;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        assert (this.level != null);
        Direction direction = (Direction)this.getBlockState().getValue((Property)IndustrialFanBlock.FACING);
        if (!direction.getAxis().isVertical()) {
            return;
        }
        BlockEntity poweredChute = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public void tick() {
        boolean server;
        super.tick();
        assert (this.level != null);
        boolean bl = server = !this.level.isClientSide || this.isVirtual();
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)DesiresConfigs.server().kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            if (this.airCurrent.maxDistance > 0.0f) {
                this.award(AllAdvancements.ENCASED_FAN);
            }
            this.sendData();
        }
        if (this.updateGenerator) {
            this.updateGenerator = false;
            this.updateGenerator();
        }
        if (this.isGenerator || this.getSpeed() == 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

