/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.neoforge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeEnumValue;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeListValue;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class NeoForgeFolderEntry
implements IConfigEntry {
    protected final List<String> path;
    protected final UnmodifiableConfig config;
    protected final ModConfigSpec spec;
    protected List<IConfigEntry> entries;

    public NeoForgeFolderEntry(UnmodifiableConfig config, ModConfigSpec spec) {
        this(new ArrayList<String>(), config, spec);
    }

    public NeoForgeFolderEntry(List<String> path, UnmodifiableConfig config, ModConfigSpec spec) {
        this.path = path;
        this.config = config;
        this.spec = spec;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.config.valueMap().forEach((s, o) -> {
                if (o instanceof UnmodifiableConfig) {
                    ArrayList<String> path = new ArrayList<String>(this.path);
                    path.add((String)s);
                    builder.add((Object)new NeoForgeFolderEntry(path, (UnmodifiableConfig)o, this.spec));
                } else if (o instanceof ModConfigSpec.ConfigValue) {
                    ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)o;
                    if (configValue.get() instanceof List) {
                        builder.add((Object)new ValueEntry(new NeoForgeListValue(configValue, (ModConfigSpec.ValueSpec)this.spec.getSpec().getRaw(configValue.getPath()))));
                    } else if (configValue.get() instanceof Enum) {
                        builder.add((Object)new ValueEntry(new NeoForgeEnumValue((ModConfigSpec.EnumValue)configValue, (ModConfigSpec.ValueSpec)this.spec.getSpec().getRaw(configValue.getPath()))));
                    } else {
                        builder.add((Object)new ValueEntry(new NeoForgeValue(configValue, (ModConfigSpec.ValueSpec)this.spec.getSpec().getRaw(configValue.getPath()))));
                    }
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.path.isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return NeoForgeValue.lastValue(this.path, "Root");
    }

    @Override
    @Nullable
    public Component getTooltip() {
        String tooltipKey;
        String translationKey = this.getTranslationKey();
        if (translationKey != null && I18n.exists((String)(tooltipKey = translationKey + ".tooltip"))) {
            return Component.translatable((String)tooltipKey);
        }
        String comment = this.spec.getLevelComment(this.path);
        if (comment != null) {
            return Component.literal((String)comment);
        }
        return null;
    }

    @Override
    @Nullable
    public String getTranslationKey() {
        return this.spec.getLevelTranslationKey(this.path);
    }
}

