/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;

public class ChimesConfig {
    private static final Gson GSON = new Gson();
    private static final File CONFIG_DIR = new File("config");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "chimes-client.toml");
    private static final File CONFIG_FILE_COMMON = new File(CONFIG_DIR, "chimes-common.toml");
    public static ChimesConfigVariables config;

    public static void initialize() {
        if (!CONFIG_DIR.exists()) {
            CONFIG_DIR.mkdirs();
        }
        if (!CONFIG_FILE.exists()) {
            // empty if block
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public static class ChimesConfigVariables {
        public boolean windChimeAnimations = true;
        public boolean bambooLeafParticles = true;
        public boolean legacyBambooWindChimeTextures = false;
        public int phantomRepelRadiusVertical = 25;
        public int phantomRepelRadiusHorizontal = 25;
    }
}

