/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.util.UUID;
import journeymap.api.services.Services;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldIdData
extends SavedData {
    private static final String DAT_FILE = "WorldUUID";
    private static final String WORLD_ID_KEY = "world_uuid";
    private CompoundTag data;

    public WorldIdData() {
        String worldID = UUID.randomUUID().toString();
        this.data = new CompoundTag();
        Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD).getDataStorage().set(DAT_FILE, (SavedData)this);
        this.data.putString(WORLD_ID_KEY, worldID);
        this.setDirty();
    }

    public static String getWorldId() {
        return WorldIdData.get().getNBTWorldID();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put(DAT_FILE, (Tag)this.data);
        return compound;
    }

    static WorldIdData get() {
        ServerLevel level = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        return (WorldIdData)level.getDataStorage().computeIfAbsent(WorldIdData.dataFactory(), DAT_FILE);
    }

    public static SavedData.Factory<WorldIdData> dataFactory() {
        return new SavedData.Factory(WorldIdData::load, WorldIdData::load, DataFixTypes.OPTIONS);
    }

    private static WorldIdData load(CompoundTag nbt, HolderLookup.Provider provider) {
        WorldIdData worldIdData = new WorldIdData();
        worldIdData.data = nbt.getCompound(DAT_FILE);
        return worldIdData;
    }

    private static WorldIdData load() {
        return new WorldIdData();
    }

    private String getNBTWorldID() {
        if (this.data.contains(WORLD_ID_KEY)) {
            return this.data.getString(WORLD_ID_KEY);
        }
        return "noWorldIDFound";
    }
}

