/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.mixin.client;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import javax.annotation.Nullable;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamicTexture.class})
public abstract class DynamicTextureMixin
implements TextureAccess {
    @Unique
    private Integer journeymap$renderWidth;
    @Unique
    private Integer journeymap$renderHeight;
    @Unique
    private final Float2ObjectMap<DynamicTexture> journeymap$scaledImageMap = new Float2ObjectOpenHashMap();

    @Shadow
    @Nullable
    public abstract NativeImage getPixels();

    @Inject(method={"close()V"}, at={@At(value="HEAD")})
    private void journeymap$onClose(CallbackInfo ci) {
        if (!this.journeymap$scaledImageMap.isEmpty()) {
            this.journeymap$scaledImageMap.values().forEach(tex -> {
                if (tex.getPixels() != null && this.getPixels() != null && tex.getPixels().pixels != this.getPixels().pixels) {
                    tex.close();
                }
            });
        }
    }

    @Override
    public int journeymap$getWidth() {
        if (this.journeymap$renderWidth != null && this.journeymap$hasImage()) {
            return this.journeymap$renderWidth;
        }
        if (this.journeymap$hasImage()) {
            return this.getPixels().getWidth();
        }
        return 0;
    }

    @Override
    public int journeymap$getHeight() {
        if (this.journeymap$renderHeight != null && this.journeymap$hasImage()) {
            return this.journeymap$renderHeight;
        }
        if (this.journeymap$hasImage()) {
            return this.getPixels().getHeight();
        }
        return 0;
    }

    @Override
    public void journeymap$setDisplayWidth(int width) {
        this.journeymap$renderWidth = width;
    }

    @Override
    public void journeymap$setDisplayHeight(int height) {
        this.journeymap$renderHeight = height;
    }

    @Override
    public DynamicTexture journeymap$getScaledImage(float drawScale) {
        if (drawScale == 1.0f && !this.journeymap$hasImage()) {
            return (DynamicTexture)this;
        }
        DynamicTexture scaledTexture = (DynamicTexture)this.journeymap$scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                NativeImage img = ImageUtil.getScaledImage(drawScale, this.getPixels(), false);
                scaledTexture = new DynamicTexture(img);
                ((TextureAccess)scaledTexture).journeymap$putScale(drawScale, scaledTexture);
                this.journeymap$scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public void journeymap$putScale(float scale, DynamicTexture tex) {
        this.journeymap$scaledImageMap.put(scale, (Object)tex);
    }

    @Override
    public boolean journeymap$hasImage() {
        return this.getPixels() != null && this.getPixels().pixels > 0L;
    }
}

