/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver.target;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.Resolver;
import org.sinytra.adapter.next.pipeline.resolver.SubResolver;
import org.sinytra.adapter.next.pipeline.resolver.injection.InjectionPointResolver;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class TargetMethodSubResolvers {
    private static final String DEPRECATED = "Ljava/lang/Deprecated;";
    public static final SubResolver CHANGED_METHOD_PARAMS = (mixin, context, clean, dirty, recipe) -> {
        MethodQualifier cleanQualifier = clean.getTargetMethod();
        Pair<ClassNode, List<MethodNode>> candidates = context.methods().findOwnMethodsByName(context.dirtyLookup(), cleanQualifier);
        if (candidates == null) {
            return null;
        }
        Configuration resolved = TargetMethodSubResolvers.resolveReplacementCandidate(mixin, context, clean, dirty, recipe, (ClassNode)candidates.getFirst(), (List)candidates.getSecond());
        if (resolved == null) {
            return null;
        }
        if (resolved.getTargetMethod() != null && !resolved.getTargetMethod().matches(cleanQualifier)) {
            return resolved;
        }
        return null;
    };
    public static final SubResolver MOVED_INTO_LAMBDA = (mixin, context, clean, dirty, recipe) -> {
        MethodQualifier cleanQualifier = clean.getTargetMethod();
        MethodContext.TargetPair target = context.methods().findOwnMethodPair(context.dirtyLookup(), cleanQualifier);
        if (target == null) {
            return null;
        }
        for (AbstractInsnNode insn : target.methodNode().instructions) {
            Object patt0$temp;
            if (!(insn instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
            if (indy.bsmArgs.length <= 1 || !((patt0$temp = indy.bsmArgs[1]) instanceof Handle)) continue;
            Handle handle = (Handle)patt0$temp;
            MethodContext.TargetPair lambda = MethodQualifier.create(handle.getName()).map(q -> context.methods().findOwnMethodPair(context.dirtyLookup(), (MethodQualifier)q)).orElse(null);
            if (lambda == null) {
                return null;
            }
            if (context.methods().findInjectionTargetInsns(lambda).isEmpty()) continue;
            return MutableConfiguration.create().setTargetMethod(lambda.methodNode());
        }
        return null;
    };

    @Nullable
    private static Configuration resolveReplacementCandidate(MixinData mixin, MixinContext context, Configuration clean, Configuration dirty, Recipe recipe, ClassNode classNode, List<MethodNode> methods) {
        if (methods.size() == 1) {
            return MutableConfiguration.create().setTargetMethod(methods.getFirst());
        }
        Resolver resolver = recipe.resolvers().get(InjectionPointResolver.class);
        List valid = methods.stream().sorted(Comparator.comparing(m -> m.desc).reversed()).flatMap(m -> resolver.resolve(mixin, context, clean, dirty.copy().setTargetMethod((MethodNode)m), recipe).maybePatch().stream().map(c -> Pair.of((Object)m, (Object)c.subConfig().setTargetMethod((MethodNode)m)))).toList();
        if (valid.size() == 1) {
            return (Configuration)((Pair)valid.getFirst()).getSecond();
        }
        List<MethodNode> nonDeprecated = valid.stream().map(Pair::getFirst).filter(m -> !TargetMethodSubResolvers.isDirtyDeprecatedMethod(context, m)).toList();
        if (nonDeprecated.size() == 1) {
            return MutableConfiguration.create().setTargetMethod(nonDeprecated.getFirst());
        }
        return null;
    }

    public static boolean isDirtyDeprecatedMethod(MixinContext context, MethodNode dirty) {
        MethodContext.TargetPair pair = context.methods().findOwnMethodPair(context.cleanLookup(), MethodQualifier.create(dirty));
        return (pair == null || !AdapterUtil.hasAnnotation(pair.methodNode().visibleAnnotations, DEPRECATED)) && !AdapterUtil.hasAnnotation(dirty.visibleAnnotations, DEPRECATED);
    }
}

