/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver.injection;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.WeighedDisambiguation;
import org.sinytra.adapter.next.env.param.MethodParameters;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.SubResolver;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class InjectionPointSubResolvers {
    private static final int INSN_RANGE = 5;
    public static final SubResolver REPLACED_TYPE = (mixin, context, clean, dirty, recipe) -> {
        AbstractInsnNode patt0$temp;
        if (!clean.getAtData().getValue().equals("INVOKE")) {
            return null;
        }
        MethodQualifier cleanQualifier = clean.getTargetMethod();
        MethodQualifier dirtyQualifier = dirty.getTargetMethod();
        MethodContext.TargetPair dirtyTarget = context.methods().findOwnMethodPair(context.dirtyLookup(), dirtyQualifier);
        if (dirtyTarget == null) {
            return null;
        }
        MethodContext.TargetPair cleanPair = context.methods().findOwnMethodPair(context.cleanLookup(), cleanQualifier);
        List<AbstractInsnNode> insns = context.methods().findInjectionTargetInsns(cleanPair);
        if (insns.isEmpty() || !((patt0$temp = insns.getFirst()) instanceof MethodInsnNode)) {
            return null;
        }
        MethodInsnNode cleanInsn = (MethodInsnNode)patt0$temp;
        InstructionMatcher cleanMatcher = MethodCallAnalyzer.findSurroundingInstructions((AbstractInsnNode)cleanInsn, 5);
        Multimap<String, MethodInsnNode> dirtyCalls = MethodCallAnalyzer.getMethodCalls(dirtyTarget.methodNode(), new ArrayList<String>());
        List<InstructionMatcher> dirtyMatchers = dirtyCalls.values().stream().map(i -> MethodCallAnalyzer.findSurroundingInstructions((AbstractInsnNode)i, 5)).toList();
        WeighedDisambiguation<MethodQualifier> magicBlackBox = WeighedDisambiguation.builder().match(() -> InjectionPointSubResolvers.testMatchers(context, cleanInsn, cleanMatcher, dirtyMatchers, false)).match(() -> InjectionPointSubResolvers.testMatchers(context, cleanInsn, cleanMatcher, dirtyMatchers, true)).match(() -> InjectionPointSubResolvers.testOverloadedMethods(context, cleanInsn, cleanPair, dirtyTarget)).resultsEqual(MethodQualifier::equals).build();
        MethodQualifier replacement = magicBlackBox.findBestMatch();
        if (replacement != null) {
            return MutableConfiguration.create().setAtData(clean.getAtData().withTarget(replacement.asDescriptor()));
        }
        return null;
    };

    private static List<MethodQualifier> testMatchers(MixinContext context, MethodInsnNode cleanInsn, InstructionMatcher cleanMatcher, List<InstructionMatcher> dirtyMatchers, boolean partial) {
        return dirtyMatchers.stream().map(m -> {
            boolean before = cleanMatcher.testBefore((InstructionMatcher)m);
            boolean after = cleanMatcher.testAfter((InstructionMatcher)m);
            boolean match = partial ? before || after : before && after;
            MethodInsnNode dirtyInsn = (MethodInsnNode)m.insn();
            if (match && InjectionPointSubResolvers.matchesMethodCall(context, cleanInsn, dirtyInsn)) {
                return dirtyInsn;
            }
            return null;
        }).filter(Objects::nonNull).map(MethodQualifier::create).toList();
    }

    private static List<MethodQualifier> testOverloadedMethods(MixinContext context, MethodInsnNode cleanInsn, MethodContext.TargetPair cleanPair, MethodContext.TargetPair dirtyPair) {
        ClassNode dirtyClass = context.dirtyLookup().getClass(cleanInsn.owner).orElse(null);
        if (dirtyClass == null) {
            return List.of();
        }
        List<Type> cleanParams = MethodParameters.getParameterTypes(cleanInsn.desc);
        List<MethodNode> methods = dirtyClass.methods.stream().filter(m -> {
            if (cleanPair.classNode().methods.stream().noneMatch(c -> c.name.equals(m.name) && c.desc.equals(m.desc)) && m.name.equals(cleanInsn.name)) {
                List<Type> dirtyParams = MethodParameters.getParameterTypes(m.desc);
                return dirtyParams.size() > cleanParams.size() && dirtyParams.subList(0, cleanParams.size()).equals(cleanParams);
            }
            return false;
        }).filter(m -> MethodCallAnalyzer.containsMethodCall(dirtyPair.methodNode(), MethodQualifier.create(m))).toList();
        return methods.size() == 1 ? List.of(MethodQualifier.create(dirtyClass, methods.getFirst())) : List.of();
    }

    private static boolean matchesMethodCall(MixinContext context, MethodInsnNode cleanInsn, MethodInsnNode dirtyInsn) {
        return cleanInsn.owner.equals(dirtyInsn.owner) && cleanInsn.name.equals(dirtyInsn.name) || context.getTypeAdapter(Type.getObjectType((String)dirtyInsn.owner), Type.getObjectType((String)cleanInsn.owner)) != null && Type.getArgumentTypes((String)cleanInsn.desc).length == Type.getArgumentTypes((String)dirtyInsn.desc).length;
    }
}

