/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline;

import com.mojang.logging.LogUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.AtData;
import org.sinytra.adapter.next.env.ann.ClassTarget;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.TxResult;
import org.sinytra.adapter.next.pipeline.config.ConfigurationImpl;
import org.sinytra.adapter.next.pipeline.processor.Processor;
import org.sinytra.adapter.next.pipeline.processor.Processors;
import org.sinytra.adapter.next.pipeline.resolver.Resolver;
import org.sinytra.adapter.next.pipeline.resolver.Resolvers;
import org.sinytra.adapter.next.type.MixinType;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.slf4j.Logger;

public class PipelineExecutor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MixinType mixinType;
    private final ClassTarget classTarget;
    private final MixinContext context;

    public PipelineExecutor(MixinType<?> mixinType, ClassTarget classTarget, MixinContext context) {
        this.mixinType = mixinType;
        this.classTarget = classTarget;
        this.context = context;
    }

    public Patch.Result execute() {
        Object res;
        MixinData data = this.parseMixinData();
        if (data == null) {
            return Patch.Result.PASS;
        }
        String mixinId = this.context.classNode().name + "#" + this.context.methodNode().name + this.context.methodNode().desc;
        Resolvers resolvers = new Resolvers();
        Processors processors = new Processors();
        ConfigurationImpl cleanConfig = new ConfigurationImpl();
        cleanConfig.setTargetClass(data.getTargetClass());
        cleanConfig.setTargetMethod(data.getTargetMethod());
        cleanConfig.setAtData(data.at());
        cleanConfig.setReturnType(Type.getReturnType((String)this.context.methodNode().desc));
        ConfigurationImpl dirtyConfig = new ConfigurationImpl(cleanConfig);
        dirtyConfig.inheritTargetClass();
        Recipe recipe = new Recipe(cleanConfig, dirtyConfig, resolvers, processors);
        this.mixinType.preProcess(data, this.context, cleanConfig, recipe);
        if (!cleanConfig.validate()) {
            LOGGER.debug(PatchInstance.MIXINPATCH, "Skipping mixin {} due to invalid CLEAN config", (Object)mixinId);
            return Patch.Result.PASS;
        }
        resolvers.freeze();
        for (Resolver resolver : resolvers.getAll()) {
            res = resolver.resolve(data, this.context, cleanConfig, dirtyConfig, recipe);
            if (res.type() == TxResult.SUCCESS) {
                dirtyConfig.mergeFrom(res.patch());
                continue;
            }
            if (res.type() != TxResult.FAIL) continue;
            LOGGER.debug(PatchInstance.MIXINPATCH, "Skipping mixin {} due to failed RESOLVER {}", (Object)mixinId, (Object)resolver.getClass().getSimpleName());
            return Patch.Result.PASS;
        }
        this.mixinType.postProcess(data, this.context, cleanConfig, dirtyConfig, recipe);
        if (!dirtyConfig.validate()) {
            LOGGER.debug(PatchInstance.MIXINPATCH, "Skipping mixin {} due to invalid DIRTY config", (Object)mixinId);
            return Patch.Result.PASS;
        }
        processors.freeze();
        for (Processor processor : processors.getAll()) {
            res = processor.process(data, this.context, dirtyConfig, recipe);
            if (res != TxResult.FAIL) continue;
            LOGGER.debug(PatchInstance.MIXINPATCH, "Skipping mixin {} due to failed PROCESSOR {}", (Object)mixinId, (Object)processor.getClass().getSimpleName());
            return Patch.Result.PASS;
        }
        return Patch.Result.APPLY;
    }

    @Nullable
    private MixinData parseMixinData() {
        AnnotationHandle atHandle = this.context.legacy().injectionPointAnnotation();
        if (atHandle == null) {
            return null;
        }
        AtData atData = AtData.parse(atHandle, this.context).orElse(null);
        if (atData == null) {
            return null;
        }
        MethodQualifier targetMethod = this.context.legacy().getTargetMethodQualifier();
        AnnotationHandle methodHandle = this.context.legacy().methodAnnotation();
        return this.mixinType.parse(this.context, this.classTarget, targetMethod, atData, methodHandle);
    }
}

