/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.kinetic;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class WrappedRenderWorld
extends VirtualRenderWorld {
    protected final BlockAndTintGetter level;
    protected final BlockPos targetPos;
    protected final BlockState material;
    protected ModelData modelData;

    public WrappedRenderWorld(ICopycatBlockEntity be) {
        super(be.getLevel(), be.getLevel().getMinBuildHeight(), be.getLevel().getHeight(), Vec3i.ZERO, () -> {});
        this.level = be.getLevel();
        this.targetPos = be.getBlockPos();
        this.material = be.getMaterial();
    }

    public BlockAndTintGetter getWrappedLevel() {
        return this.level;
    }

    public WrappedRenderWorld withModelData(ModelData modelData) {
        this.modelData = modelData;
        return this;
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        if (!pos.equals((Object)this.targetPos)) {
            return null;
        }
        return this.level.getBlockEntity(pos);
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        if (!pos.equals((Object)this.targetPos)) {
            return this.material;
        }
        return this.level.getBlockState(pos);
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pos) {
        if (!pos.equals((Object)this.targetPos)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return this.level.getFluidState(pos);
    }

    public float getShade(@NotNull Direction direction, boolean shade) {
        return 1.0f;
    }

    public int getBlockTint(BlockPos pos, ColorResolver resolver) {
        Biome plainsBiome = (Biome)Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
        return resolver.getColor(plainsBiome, (double)pos.getX(), (double)pos.getZ());
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockPos pos) {
        if (this.modelData != null && pos.equals((Object)this.targetPos)) {
            return this.modelData;
        }
        return super.getModelData(pos);
    }

    public void blockEntityChanged(BlockPos pos) {
    }
}

