/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.neoforge.client.model;

import cjminecraft.doubleslabs.api.helpers.ISlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.api.state.VerticalSlabType;
import cjminecraft.doubleslabs.client.ClientInternal;
import cjminecraft.doubleslabs.client.hooks.DynamicSlabBlockClientHooks;
import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.common.block.VerticalSlabBlock;
import cjminecraft.doubleslabs.neoforge.client.model.NeoForgeDynamicSlabBakedModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBakedModel
extends NeoForgeDynamicSlabBakedModel {
    private final BakedModel baseModel;

    public VerticalSlabBakedModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        if (!data.has(DYNAMIC_SLAB_STATE_CONTAINER) || renderType == null || state == null) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        @Nullable IDynamicSlabStateContainer stateContainer = (IDynamicSlabStateContainer)data.get(DYNAMIC_SLAB_STATE_CONTAINER);
        if (stateContainer == null) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        Direction.Axis axis = (Direction.Axis)state.getValue(VerticalSlabBlock.AXIS);
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        ISlabHelper slabHelper = Internal.getSlabHelper();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        stateContainer.runOnBlockStates((half, slabState) -> {
            BakedModel model;
            Direction direction = type.getDirection((Half)((Object)half), axis);
            BakedModel bakedModel = model = slabHelper.isVerticalSlab((BlockState)slabState) ? blockRenderDispatcher.getBlockModel(slabState) : ClientInternal.getVerticalSlabModelHelper().getVerticalSlabModel((BlockState)slabState, direction);
            if (model.getRenderTypes(slabState, rand, data).contains(renderType)) {
                List modelQuads = model.getQuads(slabState, side, rand, data, renderType);
                quads.addAll(modelQuads.stream().map(DynamicSlabBlockClientHooks.withCorrectTint(half)).toList());
            }
        });
        return quads;
    }
}

