/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.neoforge.client.model;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.client.ClientInternal;
import cjminecraft.doubleslabs.client.hooks.DynamicSlabBlockClientHooks;
import cjminecraft.doubleslabs.neoforge.client.model.NeoForgeDynamicSlabBakedModel;
import cjminecraft.doubleslabs.neoforge.common.init.DSNeoForgeBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class MixedDoubleSlabBakedModel
extends NeoForgeDynamicSlabBakedModel {
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        if (!data.has(DYNAMIC_SLAB_STATE_CONTAINER) || renderType == null) {
            return ClientInternal.getFallbackModel().getQuads(state, side, rand, data, renderType);
        }
        IDynamicSlabStateContainer stateContainer = (IDynamicSlabStateContainer)data.get(DYNAMIC_SLAB_STATE_CONTAINER);
        if (stateContainer == null) {
            return ClientInternal.getFallbackModel().getQuads(state, side, rand, data, renderType);
        }
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        boolean shouldNotCull = state == null || state.is((Block)DSNeoForgeBlocks.TRANSPARENT_MIXED_SLAB.get());
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        stateContainer.runOnBlockStates((half, slabState) -> {
            BakedModel model = blockRenderDispatcher.getBlockModel(slabState);
            if (model.getRenderTypes(slabState, rand, data).contains(renderType)) {
                List modelQuads = model.getQuads(slabState, side, rand, data, renderType);
                Direction directionToCull = half == Half.POSITIVE ? Direction.DOWN : Direction.UP;
                quads.addAll(modelQuads.stream().filter(quad -> shouldNotCull || quad.getDirection() != directionToCull).map(DynamicSlabBlockClientHooks.withCorrectTint(half)).toList());
            }
        });
        return quads;
    }
}

