/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.neoforge.client;

import cjminecraft.doubleslabs.client.ClientInternal;
import cjminecraft.doubleslabs.client.hooks.DynamicSlabBlockClientHooks;
import cjminecraft.doubleslabs.client.hooks.VerticalSlabItemClientHooks;
import cjminecraft.doubleslabs.client.model.VerticalSlabItemBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabModelBaker;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.neoforge.client.block.MixedDoubleSlabClientBlockExtensions;
import cjminecraft.doubleslabs.neoforge.client.block.VerticalSlabClientBlockExtensions;
import cjminecraft.doubleslabs.neoforge.client.model.MixedDoubleSlabBakedModel;
import cjminecraft.doubleslabs.neoforge.client.model.NeoForgeModelBaker;
import cjminecraft.doubleslabs.neoforge.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.neoforge.common.init.DSNeoForgeBlocks;
import cjminecraft.doubleslabs.neoforge.common.init.DSNeoForgeItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@Mod(value="doubleslabs", dist={Dist.CLIENT})
public class DoubleSlabsClient {
    private static final ModelResourceLocation MIXED_SLAB_MODEL = new ModelResourceLocation(DSBlocks.MIXED_SLAB_ID, "");
    private static final ModelResourceLocation TRANSPARENT_MIXED_SLAB_MODEL = new ModelResourceLocation(DSBlocks.TRANSPARENT_MIXED_SLAB_ID, "");
    private static final ModelResourceLocation VERTICAL_SLAB_ITEM_MODEL = new ModelResourceLocation(DSBlocks.VERTICAL_SLAB_ID, "inventory");

    public DoubleSlabsClient(IEventBus modBus) {
        modBus.addListener(this::replaceModels);
        modBus.addListener(this::registerClientExtensions);
        modBus.addListener(this::registerBlockColours);
        modBus.addListener(this::registerItemColours);
        modBus.addListener(this::bakeModels);
    }

    private void replaceModels(ModelEvent.ModifyBakingResult event) {
        event.getModels().put(MIXED_SLAB_MODEL, new MixedDoubleSlabBakedModel());
        event.getModels().put(TRANSPARENT_MIXED_SLAB_MODEL, new MixedDoubleSlabBakedModel());
        NeoForgeModelBaker neoforgeModelBaker = new NeoForgeModelBaker(event.getModelBakery(), Minecraft.getInstance().getModelManager());
        event.getModels().put(VERTICAL_SLAB_ITEM_MODEL, new VerticalSlabItemBakedModel(neoforgeModelBaker));
        DSBlocks.VERTICAL_SLAB.get().getStateDefinition().getPossibleStates().forEach(state -> {
            ModelResourceLocation location = BlockModelShaper.stateToModelLocation((BlockState)state);
            event.getModels().computeIfPresent(location, (l, originalModel) -> new VerticalSlabBakedModel((BakedModel)originalModel));
        });
    }

    private void bakeModels(ModelEvent.BakingCompleted event) {
        NeoForgeModelBaker neoforgeModelBaker = new NeoForgeModelBaker(event.getModelBakery(), event.getModelManager());
        VerticalSlabModelBaker verticalSlabModelBaker = new VerticalSlabModelBaker(neoforgeModelBaker);
        verticalSlabModelBaker.bakeBlocks((Iterable<Block>)BuiltInRegistries.BLOCK);
        verticalSlabModelBaker.bakeItems((Iterable<Item>)BuiltInRegistries.ITEM, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
        ClientInternal.initialise(verticalSlabModelBaker.createModelHelper());
    }

    private void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerBlock(MixedDoubleSlabClientBlockExtensions.INSTANCE, new Holder[]{DSNeoForgeBlocks.MIXED_SLAB});
        event.registerBlock(MixedDoubleSlabClientBlockExtensions.INSTANCE, new Holder[]{DSNeoForgeBlocks.TRANSPARENT_MIXED_SLAB});
        event.registerBlock(VerticalSlabClientBlockExtensions.INSTANCE, new Holder[]{DSNeoForgeBlocks.VERTICAL_SLAB});
    }

    private void registerBlockColours(RegisterColorHandlersEvent.Block event) {
        event.register(DynamicSlabBlockClientHooks.getBlockColour(), new Block[]{(Block)DSNeoForgeBlocks.MIXED_SLAB.get()});
        event.register(DynamicSlabBlockClientHooks.getBlockColour(), new Block[]{(Block)DSNeoForgeBlocks.TRANSPARENT_MIXED_SLAB.get()});
        event.register(DynamicSlabBlockClientHooks.getBlockColour(), new Block[]{(Block)DSNeoForgeBlocks.VERTICAL_SLAB.get()});
    }

    private void registerItemColours(RegisterColorHandlersEvent.Item event) {
        event.register(VerticalSlabItemClientHooks.getItemColour(), new ItemLike[]{(ItemLike)DSNeoForgeItems.VERTICAL_SLAB.get()});
    }
}

