/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.item;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.api.state.VerticalSlabType;
import cjminecraft.doubleslabs.common.Constants;
import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.common.block.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlockEntities;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.item.component.VerticalSlabContent;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VerticalSlabItem
extends BlockItem {
    public VerticalSlabItem() {
        super((Block)DSBlocks.VERTICAL_SLAB.get(), new Item.Properties().component(DSItems.VERTICAL_SLAB_CONTENT.get(), (Object)VerticalSlabContent.EMPTY));
    }

    public static ItemStack of(ItemStack slab) {
        return VerticalSlabItem.setContainedSlabItem(DSItems.VERTICAL_SLAB.get().getDefaultInstance(), slab);
    }

    public static ItemStack setContainedSlabItem(ItemStack stack, ItemStack slab) {
        ItemStack copy = slab.copyWithCount(1);
        stack.set(DSItems.VERTICAL_SLAB_CONTENT.get(), (Object)VerticalSlabContent.of(copy));
        return stack;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState originalState = level.getBlockState(pos);
        boolean result = super.placeBlock(context, state);
        Player player = context.getPlayer();
        if (player == null) {
            return result;
        }
        ItemStack stack = context.getItemInHand();
        VerticalSlabContent content = Objects.requireNonNull((VerticalSlabContent)stack.get(DSItems.VERTICAL_SLAB_CONTENT.get()));
        if (content.isEmpty()) {
            Constants.LOG.warn("Tried to place a vertical slab with no inner slab");
            return result;
        }
        VerticalSlabType newType = (VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        IHorizontalSlabHelper helper = Internal.getSlabHelper().getHorizontalSlabHelper(content.getItem()).orElseThrow();
        BlockState stateFromSlabItem = Objects.requireNonNull(helper.getStateFromStack(content.getItem(), context));
        level.getBlockEntity(pos, DSBlockEntities.DYNAMIC_SLAB.get()).ifPresent(dynamicSlab -> {
            Half half = newType == VerticalSlabType.DOUBLE ? ((VerticalSlabType)((Object)((Object)originalState.getValue(VerticalSlabBlock.TYPE)))).getHalf().getOpposite() : newType.getHalf();
            BlockState slabState = helper.getStateForHalf((BlockGetter)level, pos, stateFromSlabItem, half);
            ((IDynamicSlabStateContainer)dynamicSlab).setBlockState(half, slabState);
            if (slabState.hasBlockEntity()) {
                BlockEntity slabToPlaceBlockEntity = ((EntityBlock)slabState.getBlock()).newBlockEntity(pos, slabState);
                ((IDynamicSlabStateContainer)dynamicSlab).setBlockEntity(half, slabToPlaceBlockEntity);
            }
        });
        return result;
    }

    public String getDescriptionId(ItemStack stack) {
        VerticalSlabContent content = Objects.requireNonNull((VerticalSlabContent)stack.get(DSItems.VERTICAL_SLAB_CONTENT.get()));
        return content.getItem().getDescriptionId();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"item.vertical_slab.prefix", (Object[])new Object[]{Component.translatable((String)this.getDescriptionId(stack))});
    }
}

