/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.hooks;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.api.state.VerticalSlabType;
import cjminecraft.doubleslabs.common.block.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.block.entity.DynamicSlabBlockEntity;
import cjminecraft.doubleslabs.common.hooks.DynamicSlabBlockHooks;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.item.VerticalSlabItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlockHooks
extends DynamicSlabBlockHooks {
    @Nullable
    protected static Half getHalfFromHitResult(BlockState verticalSlabState, HitResult hitResult, BlockPos slabPos) {
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos hitPos = ((BlockHitResult)hitResult).getBlockPos();
        if (!slabPos.equals((Object)hitPos)) {
            return null;
        }
        VerticalSlabType type = (VerticalSlabType)((Object)verticalSlabState.getValue(VerticalSlabBlock.TYPE));
        if (type != VerticalSlabType.DOUBLE) {
            return type.getHalf();
        }
        Direction.Axis axis = (Direction.Axis)verticalSlabState.getValue(VerticalSlabBlock.AXIS);
        Vec3 hitLocation = hitResult.getLocation();
        double hitOffset = hitLocation.get(axis) - (double)slabPos.get(axis);
        return hitOffset > 0.5 ? Half.POSITIVE : Half.NEGATIVE;
    }

    @Nullable
    protected static Half getHalfFromLookingAtBlock(BlockState verticalSlabState, Player player, BlockPos slabPos) {
        HitResult hitResult = player.pick(player.blockInteractionRange(), 0.0f, false);
        return VerticalSlabBlockHooks.getHalfFromHitResult(verticalSlabState, hitResult, slabPos);
    }

    protected static Half getHalfFromPlayerUsingCollision(Player player, VoxelShape collisionShape, BlockState verticalSlabState, BlockPos slabPos) {
        Vec3 clipStart = player.getEyePosition();
        Vec3 clipEnd = player.getEyePosition().add(player.getLookAngle().scale(player.blockInteractionRange()));
        BlockHitResult hitResult = Objects.requireNonNull(collisionShape.clip(clipStart, clipEnd, slabPos));
        return Objects.requireNonNull(VerticalSlabBlockHooks.getHalfFromHitResult(verticalSlabState, (HitResult)hitResult, slabPos));
    }

    protected static <T> Optional<T> callOnLookingAtBlockState(BlockGetter blockGetter, BlockState state, BlockPos pos, HitResult hitResult, Function<BlockState, T> function) {
        Half slabHalf = VerticalSlabBlockHooks.getHalfFromHitResult(state, hitResult, pos);
        if (slabHalf == null) {
            return Optional.empty();
        }
        return VerticalSlabBlockHooks.callOnBlockState(blockGetter, pos, slabHalf, function);
    }

    protected static <T> Optional<T> callOnLookingAtBlockState(BlockGetter blockGetter, BlockState state, BlockPos pos, Player player, Function<BlockState, T> function) {
        Half slabHalf = VerticalSlabBlockHooks.getHalfFromLookingAtBlock(state, player, pos);
        if (slabHalf == null) {
            return Optional.empty();
        }
        return VerticalSlabBlockHooks.callOnBlockState(blockGetter, pos, slabHalf, function);
    }

    protected static <T> Optional<T> callOnBlockStateBelow(BlockGetter blockGetter, BlockState state, BlockPos pos, Entity entity, Function<BlockState, T> function) {
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        if (type != VerticalSlabType.DOUBLE) {
            return VerticalSlabBlockHooks.callOnBlockState(blockGetter, pos, type.getHalf(), function);
        }
        Half slabHalf = VerticalSlabBlockHooks.getHalfFromHitResult(state, (HitResult)new BlockHitResult(entity.position().subtract(0.0, (double)1.0E-5f, 0.0), Direction.UP, pos, true), pos);
        if (slabHalf == null) {
            return Optional.empty();
        }
        return VerticalSlabBlockHooks.callOnBlockState(blockGetter, pos, slabHalf, function);
    }

    public static Optional<Float> getDestroyProgress(Player player, BlockGetter blockGetter, BlockState state, BlockPos pos) {
        return VerticalSlabBlockHooks.callOnLookingAtBlockState(blockGetter, state, pos, player, (BlockState s) -> Float.valueOf(s.getDestroyProgress(player, blockGetter, pos))).or(() -> VerticalSlabBlockHooks.minFromBlockState(blockGetter, pos, s -> Float.valueOf(s.getDestroyProgress(player, blockGetter, pos))));
    }

    public static boolean removeBlock(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        if (player.isCreative() && player.isCrouching() && type == VerticalSlabType.DOUBLE) {
            VerticalSlabBlockHooks.playerDestroy(player, level, pos, state, level.getBlockEntity(pos), player.getMainHandItem());
            return true;
        }
        return !player.isCreative();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void playerDestroy(Player player, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        if (blockEntity instanceof IDynamicSlabStateContainer) {
            IDynamicSlabStateContainer container = (IDynamicSlabStateContainer)blockEntity;
            if (type == VerticalSlabType.DOUBLE) {
                Half halfToRemove = VerticalSlabBlockHooks.getHalfFromPlayerUsingCollision(player, state.getCollisionShape((BlockGetter)level, pos), state, pos);
                VerticalSlabBlockHooks.destroyHalf(container, player, level, pos, tool, halfToRemove, slabContainer -> {
                    if (level instanceof ServerLevel) {
                        BlockState slabState = slabContainer.getBlockState();
                        Item slabItem = slabState.getBlock().asItem();
                        Block.getDrops((BlockState)slabState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)slabContainer.getBlockEntity(), (Entity)player, (ItemStack)tool).stream().map(stack -> stack.is(slabItem) ? VerticalSlabItem.of(stack) : stack).forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
                        state.spawnAfterBreak((ServerLevel)level, pos, tool, true);
                    }
                });
                Half halfToKeep = halfToRemove.getOpposite();
                container.clearStateContainer(halfToRemove);
                level.setBlock(pos, (BlockState)state.setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.fromHalf(halfToKeep))), 3);
                return;
            }
        }
        player.causeFoodExhaustion(0.005f);
        Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
        level.removeBlock(pos, false);
    }

    public static ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, HitResult hitResult) {
        return VerticalSlabBlockHooks.callOnLookingAtBlockState((BlockGetter)level, state, pos, hitResult, (BlockState s) -> {
            ItemStack slab = s.getBlock().getCloneItemStack(level, pos, s);
            return VerticalSlabItem.of(slab);
        }).orElse(ItemStack.EMPTY);
    }

    public static List<ItemStack> getDrops(LootParams.Builder params) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof DynamicSlabBlockEntity) {
            DynamicSlabBlockEntity dynamicSlab = (DynamicSlabBlockEntity)blockEntity;
            dynamicSlab.runOnStateContainers(container -> {
                if (!container.hasBlockState()) {
                    return;
                }
                BlockState slabState = container.getBlockState();
                LootParams.Builder slabParams = params.withParameter(LootContextParams.BLOCK_STATE, (Object)slabState);
                if (container.hasBlockEntity()) {
                    slabParams = slabParams.withParameter(LootContextParams.BLOCK_ENTITY, (Object)Objects.requireNonNull(container.getBlockEntity()));
                }
                Item slabItem = slabState.getBlock().asItem();
                List<ItemStack> slabDrops = slabState.getDrops(slabParams).stream().map(stack -> stack.is(slabItem) ? VerticalSlabItem.of(stack) : stack).toList();
                drops.addAll(slabDrops);
            });
        }
        return drops;
    }

    public static Optional<SoundType> getSoundType(BlockGetter blockGetter, BlockState verticalSlabState, BlockPos pos, @Nullable Entity entity) {
        Player player;
        Optional<SoundType> destroyBlockSound;
        VerticalSlabType type = (VerticalSlabType)((Object)verticalSlabState.getValue(VerticalSlabBlock.TYPE));
        if (type != VerticalSlabType.DOUBLE) {
            return VerticalSlabBlockHooks.callOnBlockState(blockGetter, pos, type.getHalf(), BlockBehaviour.BlockStateBase::getSoundType);
        }
        if (entity instanceof Player && (destroyBlockSound = VerticalSlabBlockHooks.callOnLookingAtBlockState(blockGetter, verticalSlabState, pos, player = (Player)entity, BlockBehaviour.BlockStateBase::getSoundType)).isPresent()) {
            return destroyBlockSound;
        }
        if (entity != null) {
            return VerticalSlabBlockHooks.callOnBlockStateBelow(blockGetter, verticalSlabState, pos, entity, BlockBehaviour.BlockStateBase::getSoundType);
        }
        return VerticalSlabBlockHooks.reduceOnBlockStates(blockGetter, pos, BlockBehaviour.BlockStateBase::getSoundType, (a, b) -> a);
    }

    public static Optional<BlockParticleOption> getParticleForLanding(BlockGetter blockGetter, BlockState verticalSlabState, BlockPos pos, Entity entity) {
        return VerticalSlabBlockHooks.callOnBlockStateBelow(blockGetter, verticalSlabState, pos, entity, state -> new BlockParticleOption(ParticleTypes.BLOCK, state));
    }

    public static boolean propagateSkylightDown(BlockGetter blockGetter, BlockPos pos) {
        return VerticalSlabBlockHooks.requireEitherStates(blockGetter, pos, state -> state.propagatesSkylightDown(blockGetter, pos));
    }

    public static boolean fallOn(Level level, BlockState verticalSlabState, BlockPos pos, Entity entity, float fallDistance) {
        return VerticalSlabBlockHooks.callOnBlockStateBelow((BlockGetter)level, verticalSlabState, pos, entity, state -> {
            state.getBlock().fallOn(level, state, pos, entity, fallDistance);
            return true;
        }).orElse(false);
    }

    public static boolean updateEntityAfterFallOn(BlockGetter blockGetter, Entity entity) {
        BlockPos pos = entity.getOnPos();
        BlockState verticalSlabState = blockGetter.getBlockState(pos);
        if (!verticalSlabState.is((Block)DSBlocks.VERTICAL_SLAB.get())) {
            return false;
        }
        return VerticalSlabBlockHooks.callOnBlockStateBelow(blockGetter, verticalSlabState, pos, entity, state -> {
            state.getBlock().updateEntityAfterFallOn(blockGetter, entity);
            return true;
        }).orElse(false);
    }

    public static boolean stepOn(Level level, BlockState verticalSlabState, BlockPos pos, Entity entity) {
        return VerticalSlabBlockHooks.callOnBlockStateBelow((BlockGetter)level, verticalSlabState, pos, entity, state -> {
            state.getBlock().stepOn(level, pos, state, entity);
            return true;
        }).orElse(false);
    }
}

