/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.hooks;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.helpers.ISlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.common.Internal;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DoubleSlabBlockHooks {
    public static boolean trySeparateDoubleSlab(Player player, Level level) {
        if (player.isCreative() && !player.isCrouching()) {
            return false;
        }
        HitResult hitResult = player.pick(player.blockInteractionRange(), 0.0f, false);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        return DoubleSlabBlockHooks.trySeparateDoubleSlab(player, level, (BlockHitResult)hitResult);
    }

    private static boolean trySeparateDoubleSlab(Player player, Level level, BlockHitResult hitResult) {
        BlockPos clickedPos = hitResult.getBlockPos();
        Direction clickedSide = hitResult.getDirection();
        BlockState clickedState = level.getBlockState(clickedPos);
        ISlabHelper slabHelper = Internal.getSlabHelper();
        Optional<IHorizontalSlabHelper> optionalClickedSlabHelper = slabHelper.getHorizontalSlabHelper(clickedState);
        if (optionalClickedSlabHelper.isEmpty()) {
            return false;
        }
        IHorizontalSlabHelper clickedSlabHelper = optionalClickedSlabHelper.get();
        if (!clickedSlabHelper.isDoubleSlab(clickedState)) {
            return false;
        }
        if (clickedSide.getAxis().isVertical()) {
            return DoubleSlabBlockHooks.separateDoubleSlab(level, player, clickedSlabHelper, clickedState, clickedPos, clickedSide == Direction.UP ? Half.POSITIVE : Half.NEGATIVE);
        }
        double normalizedHitY = hitResult.getLocation().y - (double)clickedPos.getY();
        return DoubleSlabBlockHooks.separateDoubleSlab(level, player, clickedSlabHelper, clickedState, clickedPos, normalizedHitY > 0.5 ? Half.POSITIVE : Half.NEGATIVE);
    }

    private static boolean separateDoubleSlab(Level level, Player player, IHorizontalSlabHelper slabHelper, BlockState slabBlockState, BlockPos slabPos, Half halfToRemove) {
        BlockState stateToRemove = slabHelper.getStateForHalf((BlockGetter)level, slabPos, slabBlockState, halfToRemove);
        BlockState remainingSlabState = slabHelper.getStateForHalf((BlockGetter)level, slabPos, slabBlockState, halfToRemove.getOpposite());
        if (!level.setBlock(slabPos, remainingSlabState, 3)) {
            return false;
        }
        player.awardStat(Stats.BLOCK_MINED.get((Object)stateToRemove.getBlock()));
        level.levelEvent(2001, slabPos, Block.getId((BlockState)stateToRemove));
        player.causeFoodExhaustion(0.005f);
        if (!player.isCreative()) {
            Block.dropResources((BlockState)stateToRemove, (Level)level, (BlockPos)slabPos);
        }
        stateToRemove.onRemove(level, slabPos, Blocks.AIR.defaultBlockState(), false);
        return true;
    }
}

