/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.block.entity;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.api.state.ISlabStateContainer;
import cjminecraft.doubleslabs.common.init.DSBlockEntities;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class DynamicSlabBlockEntity<S extends ISlabStateContainer>
extends BlockEntity
implements IDynamicSlabStateContainer {
    protected final S negativeBlockStateContainer = this.createBlockStateContainer();
    protected final S positiveBlockStateContainer = this.createBlockStateContainer();

    public DynamicSlabBlockEntity(BlockPos pos, BlockState blockState) {
        super(DSBlockEntities.DYNAMIC_SLAB.get(), pos, blockState);
    }

    protected abstract S createBlockStateContainer();

    @Override
    public void markDirty() {
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            this.level.getLightEngine().checkBlock(this.worldPosition);
        }
    }

    @Override
    public void setBlockState(Half half, BlockState state) {
        switch (half) {
            case POSITIVE: {
                this.positiveBlockStateContainer.setBlockState(state);
                break;
            }
            case NEGATIVE: {
                this.negativeBlockStateContainer.setBlockState(state);
            }
        }
    }

    @Override
    public void setBlockEntity(Half half, @Nullable BlockEntity blockEntity) {
        switch (half) {
            case POSITIVE: {
                this.positiveBlockStateContainer.setBlockEntity(blockEntity);
                break;
            }
            case NEGATIVE: {
                this.negativeBlockStateContainer.setBlockEntity(blockEntity);
            }
        }
    }

    @Override
    public ISlabStateContainer getStateContainer(Half half) {
        return switch (half) {
            default -> throw new MatchException(null, null);
            case Half.POSITIVE -> this.positiveBlockStateContainer;
            case Half.NEGATIVE -> this.negativeBlockStateContainer;
        };
    }

    @Override
    public void runOnStateContainers(Consumer<ISlabStateContainer> consumer) {
        consumer.accept((ISlabStateContainer)this.positiveBlockStateContainer);
        consumer.accept((ISlabStateContainer)this.negativeBlockStateContainer);
    }

    @Override
    public void runOnStateContainers(BiConsumer<Half, ISlabStateContainer> consumer) {
        consumer.accept(Half.POSITIVE, (ISlabStateContainer)this.positiveBlockStateContainer);
        consumer.accept(Half.NEGATIVE, (ISlabStateContainer)this.negativeBlockStateContainer);
    }

    @Override
    public void runOnStateContainer(Half half, Consumer<ISlabStateContainer> consumer) {
        switch (half) {
            case POSITIVE: {
                consumer.accept((ISlabStateContainer)this.positiveBlockStateContainer);
                break;
            }
            case NEGATIVE: {
                consumer.accept((ISlabStateContainer)this.negativeBlockStateContainer);
            }
        }
    }

    @Override
    public <T> T callOnStateContainer(Half half, Function<ISlabStateContainer, T> consumer) {
        return switch (half) {
            default -> throw new MatchException(null, null);
            case Half.POSITIVE -> consumer.apply((ISlabStateContainer)this.positiveBlockStateContainer);
            case Half.NEGATIVE -> consumer.apply((ISlabStateContainer)this.negativeBlockStateContainer);
        };
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.positiveBlockStateContainer.setLevel(level);
        this.negativeBlockStateContainer.setLevel(level);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("positive", (Tag)this.positiveBlockStateContainer.serialize(registries));
        tag.put("negative", (Tag)this.negativeBlockStateContainer.serialize(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.positiveBlockStateContainer.deserialize(tag.getCompound("positive"), registries);
        this.negativeBlockStateContainer.deserialize(tag.getCompound("negative"), registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

