/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.client.ClientInternal;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.item.component.VerticalSlabContent;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabItemBakedModel
implements BakedModel {
    private final ItemOverrides overrides;

    public VerticalSlabItemBakedModel(ModelBaker baker) {
        this.overrides = new DynamicItemOverrideList(baker);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        return ClientInternal.getFallbackModel().getQuads(blockState, direction, randomSource);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return ClientInternal.getFallbackModel().getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return ClientInternal.getFallbackModel().getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    private static class DynamicItemOverrideList
    extends ItemOverrides {
        public DynamicItemOverrideList(ModelBaker baker) {
            super(baker, null, List.of());
        }

        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            @Nullable VerticalSlabContent content = (VerticalSlabContent)stack.get(DSItems.VERTICAL_SLAB_CONTENT.get());
            if (content != null && !content.isEmpty()) {
                ItemStack slab = content.getItem();
                return ClientInternal.getVerticalSlabModelHelper().getVerticalSlabModel(slab);
            }
            return ClientInternal.getFallbackModel();
        }
    }
}

