/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.state;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.ISlabStateContainer;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IDynamicSlabStateContainer {
    public void markDirty();

    public void setBlockState(Half var1, BlockState var2);

    public void setBlockEntity(Half var1, @Nullable BlockEntity var2);

    default public void clearStateContainer(Half half) {
        this.runOnStateContainer(half, ISlabStateContainer::clear);
    }

    public ISlabStateContainer getStateContainer(Half var1);

    public void runOnStateContainers(Consumer<ISlabStateContainer> var1);

    public void runOnStateContainers(BiConsumer<Half, ISlabStateContainer> var1);

    public void runOnStateContainer(Half var1, Consumer<ISlabStateContainer> var2);

    public <T> T callOnStateContainer(Half var1, Function<ISlabStateContainer, T> var2);

    default public void runOnBlockStates(Consumer<BlockState> consumer) {
        this.runOnStateContainers((ISlabStateContainer container) -> container.runOnBlockState(consumer));
    }

    default public void runOnBlockStates(BiConsumer<Half, BlockState> consumer) {
        this.runOnStateContainers((Half half, ISlabStateContainer container) -> container.runOnBlockState(state -> consumer.accept((Half)((Object)half), (BlockState)state)));
    }

    default public <T> Optional<T> reduceOnBlockStates(Function<BlockState, T> consumer, BiFunction<T, T, T> reducer) {
        Optional<T> resultTop = this.callOnBlockState(Half.POSITIVE, consumer);
        Optional resultBottom = this.callOnBlockState(Half.NEGATIVE, consumer);
        if (resultTop.isPresent() && resultBottom.isPresent()) {
            return Optional.of(reducer.apply(resultTop.get(), resultBottom.get()));
        }
        return resultTop.or(() -> resultBottom);
    }

    default public void runOnBlockState(Half half, Consumer<BlockState> consumer) {
        this.runOnStateContainer(half, container -> container.runOnBlockState(consumer));
    }

    default public <T> T callOnBlockState(Half half, Function<BlockState, T> function, Supplier<T> orElse) {
        return (T)this.callOnStateContainer(half, container -> container.callOnBlockState(function, orElse));
    }

    default public <T> Optional<T> callOnBlockState(Half half, Function<BlockState, T> function) {
        return this.callOnStateContainer(half, container -> container.callOnBlockState(function));
    }

    default public void runOnBlockEntities(Consumer<BlockEntity> consumer) {
        this.runOnStateContainers((ISlabStateContainer container) -> container.runOnBlockEntity(consumer));
    }

    default public void runOnBlockEntities(BiConsumer<Half, BlockEntity> consumer) {
        this.runOnStateContainers((Half half, ISlabStateContainer container) -> container.runOnBlockEntity(blockEntity -> consumer.accept((Half)((Object)half), (BlockEntity)blockEntity)));
    }

    default public void runOnBlockEntity(Half half, Consumer<BlockEntity> consumer) {
        this.runOnStateContainer(half, container -> container.runOnBlockEntity(consumer));
    }

    default public <T> T callOnBlockEntity(Half half, Function<BlockEntity, T> function, Supplier<T> orElse) {
        return (T)this.callOnStateContainer(half, container -> container.callOnBlockEntity(function, orElse));
    }

    default public <T> Optional<T> callOnBlockEntity(Half half, Function<BlockEntity, T> function) {
        return this.callOnStateContainer(half, container -> container.callOnBlockEntity(function));
    }
}

